package com.uccc.commons.logging;


import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * Created by kidbei on 2016/12/14.
 */
public class RequestWrapper extends HttpServletRequestWrapper implements LoggerWrapper{

    private long    ignoreBodySize = IGNORE_BODY_SIZE;

    private ByteArrayOutputStream out = new ByteArrayOutputStream();

    public RequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public RequestWrapper(HttpServletRequest request, long ignoreBodySize) {
        super(request);
        this.ignoreBodySize = ignoreBodySize;
    }


    @Override
    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream() {
            @Override
            public boolean isFinished() {
                return false;
            }

            @Override
            public boolean isReady() {
                return false;
            }

            @Override
            public void setReadListener(ReadListener readListener) {

            }

            private InputStream is = RequestWrapper.super.getInputStream();

            @Override
            public int read() throws IOException {
                int readInt = is.read();
                if (readInt != -1){
                    out.write(readInt);
                }
                return readInt;
            }
        };
    }


    @Override
    public long getIgnoreBodySize() {
        return ignoreBodySize;
    }

    @Override
    public ByteArrayOutputStream getOut() {
        return out;
    }

    public void setIgnoreBodySize(long ignoreBodySize) {
        this.ignoreBodySize = ignoreBodySize;
    }
}
