/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.commons.csv;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import au.com.bytecode.opencsv.bean.CsvToBean;
import au.com.bytecode.opencsv.bean.HeaderColumnNameTranslateMappingStrategy;
import au.com.bytecode.opencsv.bean.MappingStrategy;
import com.uccc.commons.csv.CsvMapperRuntimeException;
import com.uccc.commons.csv.ICsvColumnMapping;
import com.uccc.commons.csv.ICsvMapper;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CsvMapper<T>
implements ICsvMapper<T> {
    private final Map<String, String> columnMapping = new HashMap<String, String>();
    private final HashMap<String, Field> fieldMap = new HashMap();
    private final Class<T> type;

    public CsvMapper(Class<T> type) {
        this.type = type;
    }

    @Override
    public ICsvMapper<T> withMapping(Map<String, String> mapping) {
        this.columnMapping.putAll(mapping);
        return this;
    }

    @Override
    public ICsvMapper<T> withMapping(ICsvColumnMapping mapping) {
        return this.withMapping(mapping.getColumnMapping());
    }

    @Override
    public ICsvMapper<T> withMapping(String header, String property) {
        this.columnMapping.put(header, property);
        return this;
    }

    @Override
    public List<T> fromCsv(Reader reader) {
        HeaderColumnNameTranslateMappingStrategy strategy = new HeaderColumnNameTranslateMappingStrategy();
        strategy.setType(this.type);
        strategy.setColumnMapping(this.columnMapping);
        List list = new ArrayList();
        try {
            list = new CsvToBean().parse((MappingStrategy)strategy, new CSVReader(reader));
        }
        catch (Exception ex) {
            throw new CsvMapperRuntimeException(ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                    reader = null;
                }
                catch (Exception ex) {
                    throw new CsvMapperRuntimeException("Close the reader failed.", ex);
                }
            }
        }
        return list;
    }

    @Override
    public void toCsv(Writer writer, List<T> list) throws Exception {
        CSVWriter csvWriter = new CSVWriter(writer, ',', '\u0000');
        ArrayList<String[]> lines = new ArrayList<String[]>();
        for (T item : list) {
            lines.add(this.getLine(item));
        }
        csvWriter.writeNext(this.columnMapping.keySet().toArray(new String[0]));
        csvWriter.writeAll(lines);
        csvWriter.flush();
    }

    private String[] getLine(T item) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.columnMapping.keySet()) {
            if (!this.fieldMap.containsKey(key)) {
                String fieldName = this.columnMapping.get(key);
                this.fieldMap.put(key, item.getClass().getDeclaredField(fieldName));
            }
            Field field = this.fieldMap.get(key);
            field.setAccessible(true);
            Object value = field.get(item);
            list.add(value == null ? "" : value.toString());
        }
        return list.toArray(new String[0]);
    }
}

