/*
 * Decompiled with CFR 0.152.
 */
package com.uccc.commons.csv;

import com.uccc.commons.csv.Csv;
import com.uccc.commons.csv.ICsvColumnMapping;
import com.uccc.commons.csv.Ignore;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class CsvColumnMapping
implements ICsvColumnMapping {
    private Map<String, String> columnMapping;
    private final Class<?> type;

    public CsvColumnMapping(Class<?> type) {
        this.type = type;
    }

    @Override
    public Map<String, String> getColumnMapping() {
        if (this.columnMapping == null) {
            this.columnMapping = this.innerGetColumnMapping(this.type);
        }
        return this.columnMapping;
    }

    private Map<String, String> innerGetColumnMapping(Class<?> type) {
        Field[] fields;
        LinkedHashMap<String, String> mapping = new LinkedHashMap<String, String>();
        for (Field field : fields = type.getDeclaredFields()) {
            if (field.getAnnotation(Ignore.class) != null) continue;
            String header = field.getName();
            Csv csv = field.getAnnotation(Csv.class);
            if (csv != null) {
                header = csv.value();
            }
            mapping.put(header, field.getName());
        }
        return mapping;
    }
}

