/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class Util {
    private Util() {
    }

    public static <K, V> Map<K, List<V>> immutableMultimap(Map<K, List<V>> multimap) {
        LinkedHashMap<K, List<V>> result = new LinkedHashMap<K, List<V>>();
        for (Map.Entry<K, List<V>> entry : multimap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            result.put(entry.getKey(), Util.immutableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    public static void checkArgument(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    public static <T> T checkNotNull(T reference, String format, Object ... args) {
        if (reference == null) {
            throw new NullPointerException(String.format(format, args));
        }
        return reference;
    }

    public static void checkState(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw new IllegalStateException(String.format(format, args));
        }
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <T> Set<T> immutableSet(Collection<T> set) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(set));
    }

    public static String join(String separator, List<String> parts) {
        if (parts.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(parts.get(0));
        for (int i = 1; i < parts.size(); ++i) {
            result.append(separator).append(parts.get(i));
        }
        return result.toString();
    }

    public static <T> Set<T> union(Set<T> a, Set<T> b) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        result.addAll(a);
        result.addAll(b);
        return result;
    }
}

