/*
 * Decompiled with CFR 0.152.
 */
package strman;

import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import strman.Ascii;
import strman.HtmlEntities;

public abstract class Strman {
    private static final Predicate<String> NULL_STRING_PREDICATE = str -> str == null;
    private static final Supplier<String> NULL_STRING_MSG_SUPPLIER = () -> "'value' should be not null.";

    private Strman() {
    }

    public static String append(String value, String ... appends) {
        return Strman.appendArray(value, appends);
    }

    public static String appendArray(String value, String[] appends) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        if (appends == null || appends.length == 0) {
            return value;
        }
        StringJoiner joiner = new StringJoiner("");
        for (String append : appends) {
            joiner.add(append);
        }
        return value + joiner.toString();
    }

    public static Optional<String> at(String value, int index) {
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        int length = value.length();
        if (index < 0) {
            index = length + index;
        }
        return index < length && index >= 0 ? Optional.of(String.valueOf(value.charAt(index))) : Optional.empty();
    }

    public static String[] between(String value, String start, String end) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        Strman.validate(start, NULL_STRING_PREDICATE, () -> "'start' should be not null.");
        Strman.validate(end, NULL_STRING_PREDICATE, () -> "'end' should be not null.");
        String[] parts = value.split(end);
        return (String[])Arrays.stream(parts).map(subPart -> subPart.substring(subPart.indexOf(start) + start.length())).toArray(String[]::new);
    }

    public static String[] chars(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return value.split("");
    }

    public static String collapseWhitespace(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return value.trim().replaceAll("\\s\\s+", " ");
    }

    public static boolean contains(String value, String needle) {
        return Strman.contains(value, needle, false);
    }

    public static boolean contains(String value, String needle, boolean caseSensitive) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        if (caseSensitive) {
            return value.contains(needle);
        }
        return value.toLowerCase().contains(needle.toLowerCase());
    }

    public static boolean containsAll(String value, String[] needles) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return Arrays.stream(needles).allMatch(needle -> Strman.contains(value, needle, true));
    }

    public static boolean containsAll(String value, String[] needles, boolean caseSensitive) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return Arrays.stream(needles).allMatch(needle -> Strman.contains(value, needle, caseSensitive));
    }

    public static boolean containsAny(String value, String[] needles) {
        return Strman.containsAny(value, needles, false);
    }

    public static boolean containsAny(String value, String[] needles, boolean caseSensitive) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return Arrays.stream(needles).anyMatch(needle -> Strman.contains(value, needle, caseSensitive));
    }

    public static long countSubstr(String value, String subStr) {
        return Strman.countSubstr(value, subStr, true, false);
    }

    public static long countSubstr(String value, String subStr, boolean caseSensitive, boolean allowOverlapping) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return Strman.countSubstr(caseSensitive ? value : value.toLowerCase(), caseSensitive ? subStr : subStr.toLowerCase(), allowOverlapping, 0L);
    }

    public static boolean endsWith(String value, String search) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return Strman.endsWith(value, search, value.length(), true);
    }

    public static boolean endsWith(String value, String search, boolean caseSensitive) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return Strman.endsWith(value, search, value.length(), caseSensitive);
    }

    public static boolean endsWith(String value, String search, int position, boolean caseSensitive) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        int remainingLength = position - search.length();
        if (caseSensitive) {
            return value.indexOf(search, remainingLength) > -1;
        }
        return value.toLowerCase().indexOf(search.toLowerCase(), remainingLength) > -1;
    }

    public static String ensureLeft(String value, String prefix) {
        return Strman.ensureLeft(value, prefix, true);
    }

    public static String ensureLeft(String value, String prefix, boolean caseSensitive) {
        String _prefix;
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        if (caseSensitive) {
            return value.startsWith(prefix) ? value : prefix + value;
        }
        String _value = value.toLowerCase();
        return _value.startsWith(_prefix = prefix.toLowerCase()) ? value : prefix + value;
    }

    public static String base64Decode(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return new String(Base64.getDecoder().decode(value));
    }

    public static String base64Encode(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return Base64.getEncoder().encodeToString(value.getBytes());
    }

    public static String binDecode(String value) {
        return Strman.decode(value, 16, 2);
    }

    public static String binEncode(String value) {
        return Strman.encode(value, 16, 2);
    }

    public static String decDecode(String value) {
        return Strman.decode(value, 5, 10);
    }

    public static String decEncode(String value) {
        return Strman.encode(value, 5, 10);
    }

    public static String ensureRight(String value, String suffix) {
        return Strman.ensureRight(value, suffix, true);
    }

    public static String ensureRight(String value, String suffix, boolean caseSensitive) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return Strman.endsWith(value, suffix, caseSensitive) ? value : Strman.append(value, suffix);
    }

    public static String first(String value, int n) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return value.substring(0, n);
    }

    public static String head(String value) {
        return Strman.first(value, 1);
    }

    public static String format(String value, String ... params) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        Pattern p = Pattern.compile("\\{(\\w+)\\}");
        Matcher m = p.matcher(value);
        String result = value;
        while (m.find()) {
            int paramNumber = Integer.parseInt(m.group(1));
            if (params == null || paramNumber >= params.length) {
                throw new IllegalArgumentException("params does not have value for " + m.group());
            }
            result = result.replace(m.group(), params[paramNumber]);
        }
        return result;
    }

    public static String hexDecode(String value) {
        return Strman.decode(value, 4, 16);
    }

    public static String hexEncode(String value) {
        return Strman.encode(value, 4, 16);
    }

    public static int indexOf(String value, String needle, int offset, boolean caseSensitive) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        if (caseSensitive) {
            return value.indexOf(needle, offset);
        }
        return value.toLowerCase().indexOf(needle.toLowerCase(), offset);
    }

    public static boolean unequal(String first, String second) {
        return !Objects.equals(first, second);
    }

    public static boolean inequal(String first, String second) {
        return !Objects.equals(first, second);
    }

    public static String insert(String value, String substr, int index) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        Strman.validate(substr, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        if (index > value.length()) {
            return value;
        }
        return Strman.append(value.substring(0, index), substr, value.substring(index));
    }

    public static boolean isUpperCase(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isLowerCase(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isUpperCase(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String last(String value, int n) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        if (n > value.length()) {
            return value;
        }
        return value.substring(value.length() - n);
    }

    public static String leftPad(String value, String pad, int length) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        Strman.validate(pad, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        if (value.length() > length) {
            return value;
        }
        return Strman.append(Strman.repeat(pad, length - value.length()), value);
    }

    public static boolean isString(Object value) {
        if (Objects.isNull(value)) {
            throw new IllegalArgumentException("value can't be null");
        }
        return value instanceof String;
    }

    public static int lastIndexOf(String value, String needle) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return Strman.lastIndexOf(value, needle, value.length(), true);
    }

    public static int lastIndexOf(String value, String needle, boolean caseSensitive) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return Strman.lastIndexOf(value, needle, value.length(), caseSensitive);
    }

    public static int lastIndexOf(String value, String needle, int offset, boolean caseSensitive) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        Strman.validate(needle, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        if (caseSensitive) {
            return value.lastIndexOf(needle, offset);
        }
        return value.toLowerCase().lastIndexOf(needle.toLowerCase(), offset);
    }

    public static String leftTrim(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return value.replaceAll("^\\s+", "");
    }

    public static int length(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return value.length();
    }

    public static String prepend(String value, String ... prepends) {
        return Strman.prependArray(value, prepends);
    }

    public static String prependArray(String value, String[] prepends) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        if (prepends == null || prepends.length == 0) {
            return value;
        }
        StringJoiner joiner = new StringJoiner("");
        for (String prepend : prepends) {
            joiner.add(prepend);
        }
        return joiner.toString() + value;
    }

    public static String[] removeEmptyStrings(String[] strings) {
        if (Objects.isNull(strings)) {
            throw new IllegalArgumentException("Input array should not be null");
        }
        return (String[])Arrays.stream(strings).filter(str -> str != null && !str.trim().isEmpty()).toArray(String[]::new);
    }

    public static String removeLeft(String value, String prefix) {
        return Strman.removeLeft(value, prefix, true);
    }

    public static String removeLeft(String value, String prefix, boolean caseSensitive) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        Strman.validate(prefix, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        if (caseSensitive) {
            return value.startsWith(prefix) ? value.substring(prefix.length()) : value;
        }
        return value.toLowerCase().startsWith(prefix.toLowerCase()) ? value.substring(prefix.length()) : value;
    }

    public static String removeNonWords(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return value.replaceAll("[^\\w]+", "");
    }

    public static String removeRight(String value, String suffix) {
        return Strman.removeRight(value, suffix, true);
    }

    public static String removeRight(String value, String suffix, boolean caseSensitive) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        Strman.validate(suffix, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return Strman.endsWith(value, suffix, caseSensitive) ? value.substring(0, value.toLowerCase().lastIndexOf(suffix.toLowerCase())) : value;
    }

    public static String removeSpaces(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return value.replaceAll("\\s", "");
    }

    public static String repeat(String value, int multiplier) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return Stream.generate(() -> value).limit(multiplier).collect(Collectors.joining());
    }

    public static String replace(String value, String search, String newValue, boolean caseSensitive) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        Strman.validate(search, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        if (caseSensitive) {
            return value.replace(search, newValue);
        }
        return Pattern.compile(search, 2).matcher(value).replaceAll(Matcher.quoteReplacement(newValue));
    }

    public static String reverse(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return new StringBuilder(value).reverse().toString();
    }

    public static String rightPad(String value, String pad, int length) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        if (value.length() > length) {
            return value;
        }
        return Strman.append(value, Strman.repeat(pad, length - value.length()));
    }

    public static String rightTrim(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return value.replaceAll("\\s+$", "");
    }

    public static String safeTruncate(String value, int length, String filler) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        if (length == 0) {
            return "";
        }
        if (length >= value.length()) {
            return value;
        }
        String[] words = Strman.words(value);
        StringJoiner result = new StringJoiner(" ");
        int spaceCount = 0;
        for (String word : words) {
            if (result.length() + word.length() + filler.length() + spaceCount > length) break;
            result.add(word);
            ++spaceCount;
        }
        return Strman.append(result.toString(), filler);
    }

    public static String[] split(String value, String regex) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return value.split(regex);
    }

    public static String[] words(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return value.split("\\W+");
    }

    public static String truncate(String value, int length, String filler) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        if (length == 0) {
            return "";
        }
        if (length >= value.length()) {
            return value;
        }
        return Strman.append(value.substring(0, length - filler.length()), filler);
    }

    public static String htmlDecode(String encodedHtml) {
        Strman.validate(encodedHtml, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        String[] entities = encodedHtml.split("&\\W+;");
        return Arrays.stream(entities).map(e -> HtmlEntities.decodedEntities.get(e)).collect(Collectors.joining());
    }

    public static String htmlEncode(String html) {
        Strman.validate(html, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return html.chars().mapToObj(c -> "\\u" + String.format("%04x", c).toUpperCase()).map(e -> HtmlEntities.encodedEntities.get(e)).collect(Collectors.joining());
    }

    public static String shuffle(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        String[] chars = Strman.chars(value);
        Random random = new Random();
        for (int i = 0; i < chars.length; ++i) {
            int r = random.nextInt(chars.length);
            String tmp = chars[i];
            chars[i] = chars[r];
            chars[r] = tmp;
        }
        return Arrays.stream(chars).collect(Collectors.joining());
    }

    public static String slice(String value, int begin, int end) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return value.substring(begin, end);
    }

    public static String slugify(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        String transliterated = Strman.transliterate(Strman.collapseWhitespace(value.trim().toLowerCase()));
        return Arrays.stream(Strman.words(transliterated.replace("&", "-and-"))).collect(Collectors.joining("-"));
    }

    public static String transliterate(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        String result = value;
        Set<Map.Entry<String, List<String>>> entries = Ascii.ascii.entrySet();
        for (Map.Entry<String, List<String>> entry : entries) {
            for (String ch : entry.getValue()) {
                result = result.replace(ch, entry.getKey());
            }
        }
        return result;
    }

    public static String surround(String value, String prefix, String suffix) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        String _prefix = Optional.ofNullable(prefix).orElse("");
        return Strman.append(_prefix, value, Optional.ofNullable(suffix).orElse(_prefix));
    }

    public static String toCamelCase(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        String str = Strman.toStudlyCase(value);
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String toStudlyCase(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        String[] words = Strman.collapseWhitespace(value.trim()).split("\\s*(_|-|\\s)\\s*");
        return Arrays.stream(words).filter(w -> !w.trim().isEmpty()).map(w -> Strman.head(w).toUpperCase() + Strman.tail(w)).collect(Collectors.joining());
    }

    public static String tail(String value) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return Strman.last(value, value.length() - 1);
    }

    public static String toDecamelize(String value, String chr) {
        String camelCasedString = Strman.toCamelCase(value);
        String[] words = camelCasedString.split("(?=\\p{Upper})");
        return Arrays.stream(words).map(String::toLowerCase).collect(Collectors.joining(Optional.ofNullable(chr).orElse(" ")));
    }

    public static String toKebabCase(String value) {
        return Strman.toDecamelize(value, "-");
    }

    public static String toSnakeCase(String value) {
        return Strman.toDecamelize(value, "_");
    }

    public static String decode(String value, int digits, int radix) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return Arrays.stream(value.split("(?<=\\G.{" + digits + "})")).map(data -> String.valueOf(Character.toChars(Integer.parseInt(data, radix)))).collect(Collectors.joining());
    }

    public static String encode(String value, int digits, int radix) {
        Strman.validate(value, NULL_STRING_PREDICATE, NULL_STRING_MSG_SUPPLIER);
        return value.chars().mapToObj(ch -> Strman.leftPad(Integer.toString(ch, radix), "0", digits)).collect(Collectors.joining());
    }

    private static void validate(String value, Predicate<String> predicate, Supplier<String> supplier) {
        if (predicate.test(value)) {
            throw new IllegalArgumentException(supplier.get());
        }
    }

    private static long countSubstr(String value, String subStr, boolean allowOverlapping, long count) {
        int position = value.indexOf(subStr);
        if (position == -1) {
            return count;
        }
        int offset = !allowOverlapping ? position + subStr.length() : position + 1;
        return Strman.countSubstr(value.substring(offset), subStr, allowOverlapping, ++count);
    }
}

