/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns.util;

import com.relayrides.pushy.apns.util.MalformedTokenStringException;

public class TokenUtil {
    private static final String NON_HEX_CHARACTER_PATTERN = "[^0-9a-fA-F]";

    private TokenUtil() {
    }

    public static byte[] tokenStringToByteArray(String tokenString) throws MalformedTokenStringException {
        if (tokenString == null) {
            throw new NullPointerException("Token string must not be null.");
        }
        String strippedTokenString = tokenString.replaceAll(NON_HEX_CHARACTER_PATTERN, "");
        if (strippedTokenString.length() % 2 != 0) {
            throw new MalformedTokenStringException("Token strings must contain an even number of hexadecimal digits.");
        }
        byte[] tokenBytes = new byte[strippedTokenString.length() / 2];
        for (int i = 0; i < strippedTokenString.length(); i += 2) {
            tokenBytes[i / 2] = (byte)Integer.parseInt(strippedTokenString.substring(i, i + 2), 16);
        }
        return tokenBytes;
    }

    public static String tokenBytesToString(byte[] tokenBytes) {
        if (tokenBytes == null) {
            throw new NullPointerException("Token byte array must not be null.");
        }
        StringBuilder builder = new StringBuilder();
        for (byte b : tokenBytes) {
            String hexString = Integer.toHexString(b & 0xFF);
            if (hexString.length() == 1) {
                builder.append("0");
            }
            builder.append(hexString);
        }
        return builder.toString();
    }
}

