/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns.util;

import com.relayrides.pushy.apns.ApnsPushNotification;
import com.relayrides.pushy.apns.DeliveryPriority;
import java.util.Arrays;
import java.util.Date;

public class SimpleApnsPushNotification
implements ApnsPushNotification {
    private final byte[] token;
    private final String payload;
    private final Date invalidationTime;
    private final DeliveryPriority priority;

    public SimpleApnsPushNotification(byte[] token, String payload) {
        this(token, payload, null, DeliveryPriority.IMMEDIATE);
    }

    public SimpleApnsPushNotification(byte[] token, String payload, Date invalidationTime) {
        this(token, payload, invalidationTime, DeliveryPriority.IMMEDIATE);
    }

    public SimpleApnsPushNotification(byte[] token, String payload, DeliveryPriority priority) {
        this(token, payload, null, priority);
    }

    public SimpleApnsPushNotification(byte[] token, String payload, Date invalidationTime, DeliveryPriority priority) {
        this.token = token;
        this.payload = payload;
        this.invalidationTime = invalidationTime;
        this.priority = priority;
    }

    @Override
    public byte[] getToken() {
        return this.token;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public Date getDeliveryInvalidationTime() {
        return this.invalidationTime;
    }

    @Override
    public DeliveryPriority getPriority() {
        return this.priority;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.invalidationTime == null ? 0 : this.invalidationTime.hashCode());
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + Arrays.hashCode(this.token);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleApnsPushNotification other = (SimpleApnsPushNotification)obj;
        if (this.invalidationTime == null ? other.invalidationTime != null : !this.invalidationTime.equals(other.invalidationTime)) {
            return false;
        }
        if (this.payload == null ? other.payload != null : !this.payload.equals(other.payload)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        return Arrays.equals(this.token, other.token);
    }

    public String toString() {
        return "SimpleApnsPushNotification [token=" + Arrays.toString(this.token) + ", payload=" + this.payload + ", invalidationTime=" + this.invalidationTime + ", priority=" + (Object)((Object)this.priority) + "]";
    }
}

