/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextUtil {
    private static final String PROTOCOL = "TLS";
    private static final String DEFAULT_ALGORITHM = "SunX509";
    private static final Logger log = LoggerFactory.getLogger(SSLContextUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLContext createDefaultSSLContext(String pathToPKCS12File, String keystorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException, IOException {
        FileInputStream keystoreInputStream = new FileInputStream(pathToPKCS12File);
        try {
            SSLContext sSLContext = SSLContextUtil.createDefaultSSLContext(keystoreInputStream, keystorePassword);
            return sSLContext;
        }
        finally {
            try {
                keystoreInputStream.close();
            }
            catch (IOException e) {
                log.error("Failed to close keystore input stream.", (Throwable)e);
            }
        }
    }

    public static SSLContext createDefaultSSLContext(InputStream keystoreInputStream, String keystorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException, IOException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        char[] password = keystorePassword != null ? keystorePassword.toCharArray() : null;
        keyStore.load(keystoreInputStream, password);
        return SSLContextUtil.createDefaultSSLContext(keyStore, keystorePassword != null ? keystorePassword.toCharArray() : null);
    }

    public static SSLContext createDefaultSSLContext(KeyStore keyStore, char[] keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = DEFAULT_ALGORITHM;
        }
        if (keyStore.size() == 0) {
            throw new KeyStoreException("Keystore is empty; while this is legal for keystores in general, APNs clients must have at least one key.");
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
        trustManagerFactory.init((KeyStore)null);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
        keyManagerFactory.init(keyStore, keyStorePassword);
        SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return sslContext;
    }
}

