/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns.util;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ApnsPayloadBuilder {
    private String alertBody = null;
    private String localizedAlertKey = null;
    private String[] localizedAlertArguments = null;
    private String launchImageFileName = null;
    private boolean showActionButton = true;
    private String localizedActionButtonKey = null;
    private Integer badgeNumber = null;
    private String soundFileName = null;
    private String categoryName = null;
    private boolean contentAvailable = false;
    private static final String APS_KEY = "aps";
    private static final String ALERT_KEY = "alert";
    private static final String BADGE_KEY = "badge";
    private static final String SOUND_KEY = "sound";
    private static final String CATEGORY_KEY = "category";
    private static final String CONTENT_AVAILABLE_KEY = "content-available";
    private static final String ALERT_BODY_KEY = "body";
    private static final String ACTION_LOC_KEY = "action-loc-key";
    private static final String ALERT_LOC_KEY = "loc-key";
    private static final String ALERT_ARGS_KEY = "loc-args";
    private static final String LAUNCH_IMAGE_KEY = "launch-image";
    private final HashMap<String, Object> customProperties = new HashMap();
    private static final int DEFAULT_PAYLOAD_SIZE = 2048;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String DEFAULT_SOUND_FILENAME = "default";

    public ApnsPayloadBuilder setAlertBody(String alertBody) {
        if (alertBody != null && this.localizedAlertKey != null) {
            throw new IllegalStateException("Cannot set a literal alert body when a localized alert key has already been set.");
        }
        this.alertBody = alertBody;
        return this;
    }

    public ApnsPayloadBuilder setLocalizedAlertMessage(String localizedAlertKey, String[] alertArguments) {
        if (localizedAlertKey != null && this.alertBody != null) {
            throw new IllegalStateException("Cannot set a localized alert key when a literal alert body has already been set.");
        }
        if (localizedAlertKey == null && alertArguments != null) {
            throw new IllegalArgumentException("Cannot set localized alert arguments without a localized alert message key.");
        }
        this.localizedAlertKey = localizedAlertKey;
        this.localizedAlertArguments = alertArguments;
        return this;
    }

    public ApnsPayloadBuilder setLaunchImage(String launchImageFilename) {
        this.launchImageFileName = launchImageFilename;
        return this;
    }

    public ApnsPayloadBuilder setShowActionButton(boolean showActionButton) {
        this.showActionButton = showActionButton;
        return this;
    }

    public ApnsPayloadBuilder setLocalizedActionButtonKey(String localizedActionButtonKey) {
        this.localizedActionButtonKey = localizedActionButtonKey;
        return this;
    }

    public ApnsPayloadBuilder setBadgeNumber(Integer badgeNumber) {
        this.badgeNumber = badgeNumber;
        return this;
    }

    public ApnsPayloadBuilder setCategoryName(String categoryName) {
        this.categoryName = categoryName;
        return this;
    }

    public ApnsPayloadBuilder setSoundFileName(String soundFileName) {
        this.soundFileName = soundFileName;
        return this;
    }

    public ApnsPayloadBuilder setContentAvailable(boolean contentAvailable) {
        this.contentAvailable = contentAvailable;
        return this;
    }

    public ApnsPayloadBuilder addCustomProperty(String key, Object value) {
        this.customProperties.put(key, value);
        return this;
    }

    public String buildWithDefaultMaximumLength() {
        return this.buildWithMaximumLength(2048);
    }

    public String buildWithMaximumLength(int maximumPayloadLength) {
        Object alertObject;
        JSONObject payload = new JSONObject();
        JSONObject aps = new JSONObject();
        if (this.badgeNumber != null) {
            aps.put((Object)BADGE_KEY, (Object)this.badgeNumber);
        }
        if (this.soundFileName != null) {
            aps.put((Object)SOUND_KEY, (Object)this.soundFileName);
        }
        if (this.categoryName != null) {
            aps.put((Object)CATEGORY_KEY, (Object)this.categoryName);
        }
        if (this.contentAvailable) {
            aps.put((Object)CONTENT_AVAILABLE_KEY, (Object)1);
        }
        if ((alertObject = this.createAlertObject()) != null) {
            aps.put((Object)ALERT_KEY, alertObject);
        }
        payload.put((Object)APS_KEY, (Object)aps);
        for (Map.Entry<String, Object> entry : this.customProperties.entrySet()) {
            payload.put((Object)entry.getKey(), entry.getValue());
        }
        String payloadString = payload.toJSONString();
        int initialPayloadLength = payloadString.getBytes(UTF8).length;
        if (initialPayloadLength <= maximumPayloadLength) {
            return payloadString;
        }
        if (this.alertBody != null) {
            this.replaceMessageBody(payload, "");
            int payloadLengthWithEmptyMessage = payload.toJSONString().getBytes(UTF8).length;
            if (payloadLengthWithEmptyMessage > maximumPayloadLength) {
                throw new IllegalArgumentException("Payload exceeds maximum length even with an empty message body.");
            }
            int maximumMessageBodyLength = maximumPayloadLength - payloadLengthWithEmptyMessage;
            this.replaceMessageBody(payload, this.abbreviateString(this.alertBody, maximumMessageBodyLength--));
            while (payload.toJSONString().getBytes(UTF8).length > maximumPayloadLength) {
                this.replaceMessageBody(payload, this.abbreviateString(this.alertBody, maximumMessageBodyLength--));
            }
            return payload.toJSONString();
        }
        throw new IllegalArgumentException(String.format("Payload length is %d bytes (with a maximum of %d bytes) and cannot be shortened.", initialPayloadLength, maximumPayloadLength));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void replaceMessageBody(JSONObject payload, String messageBody) {
        JSONObject aps = (JSONObject)payload.get((Object)APS_KEY);
        Object alert = aps.get((Object)ALERT_KEY);
        if (alert == null) throw new IllegalArgumentException("Payload has no message body.");
        if (alert instanceof String) {
            aps.put((Object)ALERT_KEY, (Object)messageBody);
            return;
        } else {
            JSONObject alertObject = (JSONObject)alert;
            if (alertObject.get((Object)ALERT_BODY_KEY) == null) throw new IllegalArgumentException("Payload has no message body.");
            alertObject.put((Object)ALERT_BODY_KEY, (Object)messageBody);
        }
    }

    private final String abbreviateString(String string, int maximumLength) {
        if (string.length() <= maximumLength) {
            return string;
        }
        if (maximumLength <= 3) {
            throw new IllegalArgumentException("Cannot abbreviate string to fewer than three characters.");
        }
        return string.substring(0, maximumLength - 3) + "...";
    }

    private Object createAlertObject() {
        if (this.hasAlertContent()) {
            if (this.shouldRepresentAlertAsString()) {
                return this.alertBody;
            }
            JSONObject alert = new JSONObject();
            if (this.alertBody != null) {
                alert.put((Object)ALERT_BODY_KEY, (Object)this.alertBody);
            }
            if (this.showActionButton) {
                if (this.localizedActionButtonKey != null) {
                    alert.put((Object)ACTION_LOC_KEY, (Object)this.localizedActionButtonKey);
                }
            } else {
                alert.put((Object)ACTION_LOC_KEY, null);
            }
            if (this.localizedAlertKey != null) {
                alert.put((Object)ALERT_LOC_KEY, (Object)this.localizedAlertKey);
                if (this.localizedAlertArguments != null) {
                    JSONArray alertArgs = new JSONArray();
                    for (String arg : this.localizedAlertArguments) {
                        alertArgs.add((Object)arg);
                    }
                    alert.put((Object)ALERT_ARGS_KEY, (Object)alertArgs);
                }
            }
            if (this.launchImageFileName != null) {
                alert.put((Object)LAUNCH_IMAGE_KEY, (Object)this.launchImageFileName);
            }
            return alert;
        }
        return null;
    }

    private boolean hasAlertContent() {
        return this.alertBody != null || this.localizedAlertKey != null || this.localizedActionButtonKey != null || this.launchImageFileName != null || !this.showActionButton;
    }

    private boolean shouldRepresentAlertAsString() {
        return this.alertBody != null && this.launchImageFileName == null && this.showActionButton && this.localizedActionButtonKey == null;
    }
}

