/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.relayrides.pushy.apns.ApnsPushNotification;
import com.relayrides.pushy.apns.SendableApnsPushNotification;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

class SentNotificationBuffer<E extends ApnsPushNotification> {
    private final int capacity;
    private final ArrayDeque<SendableApnsPushNotification<E>> sentNotifications;

    public SentNotificationBuffer(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be positive.");
        }
        this.capacity = capacity;
        this.sentNotifications = new ArrayDeque();
    }

    public synchronized void addSentNotification(SendableApnsPushNotification<E> notification) {
        this.sentNotifications.addLast(notification);
        while (this.sentNotifications.size() > this.capacity) {
            this.sentNotifications.removeFirst();
        }
    }

    public synchronized void clearNotificationsBeforeSequenceNumber(int sequenceNumber) {
        while (!this.sentNotifications.isEmpty() && sequenceNumber - this.sentNotifications.getFirst().getSequenceNumber() > 0) {
            this.sentNotifications.removeFirst();
        }
    }

    public synchronized E getNotificationWithSequenceNumber(int sequenceNumber) {
        for (SendableApnsPushNotification<E> sentNotification : this.sentNotifications) {
            if (sentNotification.getSequenceNumber() != sequenceNumber) continue;
            return sentNotification.getPushNotification();
        }
        return null;
    }

    public synchronized List<E> getAllNotificationsAfterSequenceNumber(int sequenceNumber) {
        ArrayList<E> notifications = new ArrayList<E>(this.sentNotifications.size());
        for (SendableApnsPushNotification<E> sentNotification : this.sentNotifications) {
            if (sentNotification.getSequenceNumber() - sequenceNumber <= 0) continue;
            notifications.add(sentNotification.getPushNotification());
        }
        notifications.trimToSize();
        return notifications;
    }

    public void clearAllNotifications() {
        this.sentNotifications.clear();
    }

    protected int size() {
        return this.sentNotifications.size();
    }

    protected Integer getLowestSequenceNumber() {
        try {
            return this.sentNotifications.getFirst().getSequenceNumber();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    protected Integer getHighestSequenceNumber() {
        try {
            return this.sentNotifications.getLast().getSequenceNumber();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

