/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.relayrides.pushy.apns.ApnsConnectionConfiguration;
import com.relayrides.pushy.apns.FeedbackConnectionConfiguration;

public class PushManagerConfiguration {
    private int concurrentConnectionCount = 1;
    private ApnsConnectionConfiguration connectionConfiguration = new ApnsConnectionConfiguration();
    private FeedbackConnectionConfiguration feedbackConfiguration = new FeedbackConnectionConfiguration();

    public PushManagerConfiguration() {
    }

    public PushManagerConfiguration(PushManagerConfiguration configuration) {
        this.concurrentConnectionCount = configuration.getConcurrentConnectionCount();
        this.connectionConfiguration = new ApnsConnectionConfiguration(configuration.getConnectionConfiguration());
        this.feedbackConfiguration = new FeedbackConnectionConfiguration(configuration.getFeedbackConnectionConfiguration());
    }

    public int getConcurrentConnectionCount() {
        return this.concurrentConnectionCount;
    }

    public void setConcurrentConnectionCount(int concurrentConnectionCount) {
        this.concurrentConnectionCount = concurrentConnectionCount;
    }

    public ApnsConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public void setConnectionConfiguration(ApnsConnectionConfiguration connectionConfiguration) {
        if (connectionConfiguration == null) {
            throw new NullPointerException("Connection configuration must not be null.");
        }
        this.connectionConfiguration = connectionConfiguration;
    }

    public FeedbackConnectionConfiguration getFeedbackConnectionConfiguration() {
        return this.feedbackConfiguration;
    }

    public void setFeedbackConnectionConfiguration(FeedbackConnectionConfiguration feedbackConnectionConfiguration) {
        if (feedbackConnectionConfiguration == null) {
            throw new NullPointerException("Feedback connection configuration must not be null.");
        }
        this.feedbackConfiguration = feedbackConnectionConfiguration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.concurrentConnectionCount;
        result = 31 * result + (this.connectionConfiguration == null ? 0 : this.connectionConfiguration.hashCode());
        result = 31 * result + (this.feedbackConfiguration == null ? 0 : this.feedbackConfiguration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PushManagerConfiguration other = (PushManagerConfiguration)obj;
        if (this.concurrentConnectionCount != other.concurrentConnectionCount) {
            return false;
        }
        if (this.connectionConfiguration == null ? other.connectionConfiguration != null : !this.connectionConfiguration.equals(other.connectionConfiguration)) {
            return false;
        }
        return !(this.feedbackConfiguration == null ? other.feedbackConfiguration != null : !this.feedbackConfiguration.equals(other.feedbackConfiguration));
    }
}

