/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.relayrides.pushy.apns.ApnsConnection;
import com.relayrides.pushy.apns.ApnsConnectionListener;
import com.relayrides.pushy.apns.ApnsConnectionPool;
import com.relayrides.pushy.apns.ApnsEnvironment;
import com.relayrides.pushy.apns.ApnsPushNotification;
import com.relayrides.pushy.apns.ExpiredToken;
import com.relayrides.pushy.apns.ExpiredTokenListener;
import com.relayrides.pushy.apns.FailedConnectionListener;
import com.relayrides.pushy.apns.FeedbackServiceConnection;
import com.relayrides.pushy.apns.FeedbackServiceListener;
import com.relayrides.pushy.apns.PushManagerConfiguration;
import com.relayrides.pushy.apns.RejectedNotificationListener;
import com.relayrides.pushy.apns.RejectedNotificationReason;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushManager<T extends ApnsPushNotification>
implements ApnsConnectionListener<T>,
FeedbackServiceListener {
    private final BlockingQueue<T> queue;
    private final LinkedBlockingQueue<T> retryQueue = new LinkedBlockingQueue();
    private final ApnsEnvironment environment;
    private final SSLContext sslContext;
    private final PushManagerConfiguration configuration;
    private final String name;
    private static final AtomicInteger pushManagerCounter = new AtomicInteger(0);
    private int connectionCounter = 0;
    private int feedbackConnectionCounter = 0;
    private final HashSet<ApnsConnection<T>> activeConnections = new HashSet();
    private final ApnsConnectionPool<T> writableConnectionPool = new ApnsConnectionPool();
    private final Object feedbackConnectionMonitor = new Object();
    private FeedbackServiceConnection feedbackConnection;
    private List<ExpiredToken> expiredTokens;
    private final List<RejectedNotificationListener<? super T>> rejectedNotificationListeners = new ArrayList<RejectedNotificationListener<? super T>>();
    private final List<FailedConnectionListener<? super T>> failedConnectionListeners = new ArrayList<FailedConnectionListener<? super T>>();
    private final List<ExpiredTokenListener<? super T>> expiredTokenListeners = new ArrayList<ExpiredTokenListener<? super T>>();
    private Thread dispatchThread;
    private boolean dispatchThreadShouldContinue = true;
    private final NioEventLoopGroup eventLoopGroup;
    private final boolean shouldShutDownEventLoopGroup;
    private final ExecutorService listenerExecutorService;
    private final boolean shouldShutDownListenerExecutorService;
    private boolean shutDownStarted = false;
    private boolean shutDownFinished = false;
    private static final Logger log = LoggerFactory.getLogger(PushManager.class);

    public PushManager(ApnsEnvironment environment, SSLContext sslContext, NioEventLoopGroup eventLoopGroup, ExecutorService listenerExecutorService, BlockingQueue<T> queue, PushManagerConfiguration configuration, String name) {
        LinkedBlockingQueue linkedBlockingQueue = this.queue = queue != null ? queue : new LinkedBlockingQueue();
        if (environment == null) {
            throw new NullPointerException("Environment must not be null.");
        }
        this.environment = environment;
        if (sslContext == null) {
            throw new NullPointerException("SSL context must not be null.");
        }
        this.sslContext = sslContext;
        if (configuration == null) {
            throw new NullPointerException("Configuration object must not be null.");
        }
        this.configuration = new PushManagerConfiguration(configuration);
        String string = this.name = name == null ? String.format("PushManager-%d", pushManagerCounter.getAndIncrement()) : name;
        if (eventLoopGroup != null) {
            this.eventLoopGroup = eventLoopGroup;
            this.shouldShutDownEventLoopGroup = false;
        } else {
            int threadCount = Math.min(this.configuration.getConcurrentConnectionCount(), Runtime.getRuntime().availableProcessors() * 2);
            this.eventLoopGroup = new NioEventLoopGroup(threadCount);
            this.shouldShutDownEventLoopGroup = true;
        }
        if (listenerExecutorService != null) {
            this.listenerExecutorService = listenerExecutorService;
            this.shouldShutDownListenerExecutorService = false;
        } else {
            this.listenerExecutorService = Executors.newSingleThreadExecutor();
            this.shouldShutDownListenerExecutorService = true;
        }
    }

    public synchronized void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("Push manager has already been started.");
        }
        if (this.isShutDown()) {
            throw new IllegalStateException("Push manager has already been shut down and may not be restarted.");
        }
        log.info("{} starting.", (Object)this.name);
        for (int i = 0; i < this.configuration.getConcurrentConnectionCount(); ++i) {
            this.startNewConnection();
        }
        this.createAndStartDispatchThread();
    }

    private void createAndStartDispatchThread() {
        this.dispatchThread = this.createDispatchThread();
        this.dispatchThread.setUncaughtExceptionHandler(new DispatchThreadExceptionHandler(this));
        this.dispatchThread.start();
    }

    protected Thread createDispatchThread() {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                while (PushManager.this.dispatchThreadShouldContinue) {
                    try {
                        ApnsConnection<ApnsPushNotification> connection = PushManager.this.writableConnectionPool.getNextConnection();
                        ApnsPushNotification notificationToRetry = (ApnsPushNotification)PushManager.this.retryQueue.poll();
                        if (notificationToRetry != null) {
                            connection.sendNotification(notificationToRetry);
                            continue;
                        }
                        if (PushManager.this.shutDownStarted) {
                            connection.shutdownGracefully();
                            PushManager.this.writableConnectionPool.removeConnection(connection);
                            continue;
                        }
                        connection.sendNotification((ApnsPushNotification)PushManager.this.queue.take());
                    }
                    catch (InterruptedException e) {}
                }
            }
        });
    }

    public boolean isStarted() {
        if (this.isShutDown()) {
            return false;
        }
        return this.dispatchThread != null;
    }

    public boolean isShutDown() {
        return this.shutDownStarted;
    }

    public synchronized void shutdown() throws InterruptedException {
        this.shutdown(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<T> shutdown(long timeout) throws InterruptedException {
        if (this.isShutDown()) {
            log.warn("{} has already been shut down; shutting down multiple times is harmless, but may indicate a problem elsewhere.", (Object)this.name);
        } else {
            log.info("{} shutting down.", (Object)this.name);
        }
        if (this.shutDownFinished) {
            return new ArrayList<T>(this.retryQueue);
        }
        if (!this.isStarted()) {
            throw new IllegalStateException("Push manager has not yet been started and cannot be shut down.");
        }
        this.shutDownStarted = true;
        Object object = this.feedbackConnectionMonitor;
        synchronized (object) {
            if (this.feedbackConnection != null) {
                this.feedbackConnection.shutdownImmediately();
            }
        }
        this.dispatchThread.interrupt();
        Date deadline = timeout > 0L ? new Date(System.currentTimeMillis() + timeout) : null;
        this.waitForAllConnectionsToFinish(deadline);
        this.dispatchThreadShouldContinue = false;
        this.dispatchThread.interrupt();
        this.dispatchThread.join();
        if (deadline == null) {
            assert (this.retryQueue.isEmpty());
            assert (this.activeConnections.isEmpty());
        }
        Collection<Object> collection = this.activeConnections;
        synchronized (collection) {
            for (ApnsConnection<T> connection : this.activeConnections) {
                connection.shutdownImmediately();
            }
        }
        collection = this.rejectedNotificationListeners;
        synchronized (collection) {
            this.rejectedNotificationListeners.clear();
        }
        collection = this.failedConnectionListeners;
        synchronized (collection) {
            this.failedConnectionListeners.clear();
        }
        collection = this.expiredTokenListeners;
        synchronized (collection) {
            this.expiredTokenListeners.clear();
        }
        if (this.shouldShutDownListenerExecutorService) {
            this.listenerExecutorService.shutdown();
        }
        if (this.shouldShutDownEventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully().await();
        }
        this.shutDownFinished = true;
        return new ArrayList<T>(this.retryQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRejectedNotificationListener(RejectedNotificationListener<? super T> listener) {
        if (this.isShutDown()) {
            throw new IllegalStateException("Rejected notification listeners may not be registered after a push manager has been shut down.");
        }
        List<RejectedNotificationListener<? super T>> list = this.rejectedNotificationListeners;
        synchronized (list) {
            this.rejectedNotificationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterRejectedNotificationListener(RejectedNotificationListener<? super T> listener) {
        List<RejectedNotificationListener<? super T>> list = this.rejectedNotificationListeners;
        synchronized (list) {
            return this.rejectedNotificationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFailedConnectionListener(FailedConnectionListener<? super T> listener) {
        if (this.isShutDown()) {
            throw new IllegalStateException("Failed connection listeners may not be registered after a push manager has been shut down.");
        }
        List<FailedConnectionListener<? super T>> list = this.failedConnectionListeners;
        synchronized (list) {
            this.failedConnectionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterFailedConnectionListener(FailedConnectionListener<? super T> listener) {
        List<FailedConnectionListener<? super T>> list = this.failedConnectionListeners;
        synchronized (list) {
            return this.failedConnectionListeners.remove(listener);
        }
    }

    public String getName() {
        return this.name;
    }

    public BlockingQueue<T> getQueue() {
        return this.queue;
    }

    protected BlockingQueue<T> getRetryQueue() {
        return this.retryQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExpiredTokenListener(ExpiredTokenListener<? super T> listener) {
        if (this.isShutDown()) {
            throw new IllegalStateException("Expired token listeners may not be registered after a push manager has been shut down.");
        }
        List<ExpiredTokenListener<? super T>> list = this.expiredTokenListeners;
        synchronized (list) {
            this.expiredTokenListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterExpiredTokenListener(ExpiredTokenListener<? super T> listener) {
        List<ExpiredTokenListener<? super T>> list = this.expiredTokenListeners;
        synchronized (list) {
            return this.expiredTokenListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void requestExpiredTokens() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Push manager has not been started yet.");
        }
        if (this.isShutDown()) {
            throw new IllegalStateException("Push manager has already been shut down.");
        }
        Object object = this.feedbackConnectionMonitor;
        synchronized (object) {
            if (this.feedbackConnection == null) {
                this.expiredTokens = new ArrayList<ExpiredToken>();
                this.feedbackConnection = new FeedbackServiceConnection(this.environment, this.sslContext, this.eventLoopGroup, this.configuration.getFeedbackConnectionConfiguration(), this, String.format("%s-feedbackConnection-%d", this.name, this.feedbackConnectionCounter++));
                this.feedbackConnection.connect();
            }
        }
    }

    @Override
    public void handleConnectionSuccess(FeedbackServiceConnection connection) {
        log.trace("Feedback connection succeeded: {}", (Object)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleConnectionFailure(FeedbackServiceConnection connection, final Throwable cause) {
        log.trace("Feedback connection failed: {}", (Object)connection, (Object)cause);
        List<FailedConnectionListener<? super T>> list = this.feedbackConnectionMonitor;
        synchronized (list) {
            this.feedbackConnection = null;
        }
        list = this.failedConnectionListeners;
        synchronized (list) {
            final PushManager pushManager = this;
            for (final FailedConnectionListener<? super T> failedConnectionListener : this.failedConnectionListeners) {
                this.listenerExecutorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        failedConnectionListener.handleFailedConnection(pushManager, cause);
                    }
                });
            }
        }
    }

    @Override
    public void handleExpiredToken(FeedbackServiceConnection connection, ExpiredToken token) {
        log.trace("Received expired token {} from feedback connection {}.", (Object)token, (Object)connection);
        this.expiredTokens.add(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleConnectionClosure(FeedbackServiceConnection connection) {
        log.trace("Feedback connection closed: {}", (Object)connection);
        final PushManager pushManager = this;
        final ArrayList<ExpiredToken> expiredTokens = new ArrayList<ExpiredToken>(this.expiredTokens);
        Object object = this.expiredTokenListeners;
        synchronized (object) {
            for (final ExpiredTokenListener<? super T> expiredTokenListener : this.expiredTokenListeners) {
                this.listenerExecutorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        expiredTokenListener.handleExpiredTokens(pushManager, expiredTokens);
                    }
                });
            }
        }
        object = this.feedbackConnectionMonitor;
        synchronized (object) {
            this.feedbackConnection = null;
            this.expiredTokens = null;
        }
    }

    @Override
    public void handleConnectionSuccess(ApnsConnection<T> connection) {
        log.trace("Connection succeeded: {}", connection);
        if (this.dispatchThreadShouldContinue) {
            this.writableConnectionPool.addConnection(connection);
        } else {
            connection.shutdownImmediately();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleConnectionFailure(ApnsConnection<T> connection, final Throwable cause) {
        log.trace("Connection failed: {}", connection, (Object)cause);
        this.removeActiveConnection(connection);
        List<FailedConnectionListener<? super T>> list = this.failedConnectionListeners;
        synchronized (list) {
            final PushManager pushManager = this;
            for (final FailedConnectionListener<? super T> failedConnectionListener : this.failedConnectionListeners) {
                this.listenerExecutorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        failedConnectionListener.handleFailedConnection(pushManager, cause);
                    }
                });
            }
        }
        if (this.shouldReplaceClosedConnection()) {
            this.startNewConnection();
        }
    }

    @Override
    public void handleConnectionWritabilityChange(ApnsConnection<T> connection, boolean writable) {
        log.trace("Writability for {} changed to {}", connection, (Object)writable);
        if (writable) {
            this.writableConnectionPool.addConnection(connection);
        } else {
            this.writableConnectionPool.removeConnection(connection);
            this.dispatchThread.interrupt();
        }
    }

    @Override
    public void handleConnectionClosure(final ApnsConnection<T> connection) {
        log.trace("Connection closed: {}", connection);
        this.writableConnectionPool.removeConnection(connection);
        this.dispatchThread.interrupt();
        final PushManager pushManager = this;
        this.listenerExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    connection.waitForPendingWritesToFinish();
                    if (pushManager.shouldReplaceClosedConnection()) {
                        pushManager.startNewConnection();
                    }
                    PushManager.this.removeActiveConnection(connection);
                }
                catch (InterruptedException e) {
                    log.warn("{} interrupted while waiting for closed connection's pending operations to finish.", (Object)pushManager.name);
                }
            }
        });
    }

    @Override
    public void handleWriteFailure(ApnsConnection<T> connection, T notification, Throwable cause) {
        this.retryQueue.add(notification);
        this.dispatchThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRejectedNotification(ApnsConnection<T> connection, T rejectedNotification, RejectedNotificationReason reason) {
        log.trace("{} rejected {}: {}", new Object[]{connection, rejectedNotification, reason});
        final PushManager pushManager = this;
        List<RejectedNotificationListener<? super T>> list = this.rejectedNotificationListeners;
        synchronized (list) {
            for (final RejectedNotificationListener<? super T> rejectedNotificationListener : this.rejectedNotificationListeners) {
                this.listenerExecutorService.execute(new Runnable((ApnsPushNotification)rejectedNotification, reason){
                    final /* synthetic */ ApnsPushNotification val$rejectedNotification;
                    final /* synthetic */ RejectedNotificationReason val$reason;
                    {
                        this.val$rejectedNotification = apnsPushNotification;
                        this.val$reason = rejectedNotificationReason;
                    }

                    @Override
                    public void run() {
                        rejectedNotificationListener.handleRejectedNotification(pushManager, this.val$rejectedNotification, this.val$reason);
                    }
                });
            }
        }
    }

    @Override
    public void handleUnprocessedNotifications(ApnsConnection<T> connection, Collection<T> unprocessedNotifications) {
        log.trace("{} returned {} unprocessed notifications", connection, (Object)unprocessedNotifications.size());
        this.retryQueue.addAll(unprocessedNotifications);
        this.dispatchThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewConnection() {
        HashSet<ApnsConnection<T>> hashSet = this.activeConnections;
        synchronized (hashSet) {
            ApnsConnection connection = new ApnsConnection(this.environment, this.sslContext, this.eventLoopGroup, this.configuration.getConnectionConfiguration(), this, String.format("%s-connection-%d", this.name, this.connectionCounter++));
            connection.connect();
            this.activeConnections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeActiveConnection(ApnsConnection<T> connection) {
        HashSet<ApnsConnection<T>> hashSet = this.activeConnections;
        synchronized (hashSet) {
            boolean removedConnection = this.activeConnections.remove(connection);
            assert (removedConnection);
            if (this.activeConnections.isEmpty()) {
                this.activeConnections.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAllConnectionsToFinish(Date deadline) throws InterruptedException {
        HashSet<ApnsConnection<T>> hashSet = this.activeConnections;
        synchronized (hashSet) {
            while (!this.activeConnections.isEmpty() && !PushManager.hasDeadlineExpired(deadline)) {
                if (deadline != null) {
                    this.activeConnections.wait(PushManager.getMillisToWaitForDeadline(deadline));
                    continue;
                }
                this.activeConnections.wait();
            }
        }
    }

    private static long getMillisToWaitForDeadline(Date deadline) {
        return Math.max(deadline.getTime() - System.currentTimeMillis(), 1L);
    }

    private static boolean hasDeadlineExpired(Date deadline) {
        if (deadline != null) {
            return System.currentTimeMillis() > deadline.getTime();
        }
        return false;
    }

    private boolean shouldReplaceClosedConnection() {
        if (this.shutDownStarted) {
            if (this.dispatchThreadShouldContinue) {
                return !this.retryQueue.isEmpty();
            }
            return false;
        }
        return true;
    }

    private static class DispatchThreadExceptionHandler<T extends ApnsPushNotification>
    implements Thread.UncaughtExceptionHandler {
        private final Logger log = LoggerFactory.getLogger(DispatchThreadExceptionHandler.class);
        final PushManager<T> manager;

        public DispatchThreadExceptionHandler(PushManager<T> manager) {
            this.manager = manager;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.log.error("Dispatch thread for {} died unexpectedly. Please file a bug with the exception details.", (Object)((PushManager)this.manager).name, (Object)e);
            if (this.manager.isStarted()) {
                ((PushManager)this.manager).createAndStartDispatchThread();
            }
        }
    }
}

