/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.relayrides.pushy.apns.ApnsEnvironment;
import com.relayrides.pushy.apns.ExpiredToken;
import com.relayrides.pushy.apns.FeedbackConnectionConfiguration;
import com.relayrides.pushy.apns.FeedbackServiceListener;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Date;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackServiceConnection {
    private final ApnsEnvironment environment;
    private final SSLContext sslContext;
    private final NioEventLoopGroup eventLoopGroup;
    private final FeedbackConnectionConfiguration configuration;
    private final FeedbackServiceListener listener;
    private final String name;
    private final Object channelRegistrationMonitor = new Object();
    private ChannelFuture connectFuture;
    private volatile boolean handshakeCompleted = false;
    private volatile boolean closeOnRegistration;
    private static final Logger log = LoggerFactory.getLogger(FeedbackServiceConnection.class);

    public FeedbackServiceConnection(ApnsEnvironment environment, SSLContext sslContext, NioEventLoopGroup eventLoopGroup, FeedbackConnectionConfiguration configuration, FeedbackServiceListener listener, String name) {
        if (environment == null) {
            throw new NullPointerException("Environment must not be null.");
        }
        if (sslContext == null) {
            throw new NullPointerException("SSL context must not be null.");
        }
        if (eventLoopGroup == null) {
            throw new NullPointerException("Event loop group must not be null.");
        }
        if (configuration == null) {
            throw new NullPointerException("Feedback service connection configuration must not be null.");
        }
        if (name == null) {
            throw new NullPointerException("Feedback service connection name must not be null.");
        }
        this.environment = environment;
        this.sslContext = sslContext;
        this.eventLoopGroup = eventLoopGroup;
        this.configuration = configuration;
        this.listener = listener;
        this.name = name;
    }

    public synchronized void connect() {
        if (this.connectFuture != null) {
            throw new IllegalStateException(String.format("%s already started a connection attempt.", this.name));
        }
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)this.eventLoopGroup);
        bootstrap.channel(NioSocketChannel.class);
        final FeedbackServiceConnection feedbackConnection = this;
        bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                SSLEngine sslEngine = feedbackConnection.sslContext.createSSLEngine();
                sslEngine.setUseClientMode(true);
                pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                pipeline.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(feedbackConnection.configuration.getReadTimeout()));
                pipeline.addLast("decoder", (ChannelHandler)new ExpiredTokenDecoder());
                pipeline.addLast("handler", (ChannelHandler)new FeedbackClientHandler(feedbackConnection));
            }
        });
        this.connectFuture = bootstrap.connect(this.environment.getFeedbackHost(), this.environment.getFeedbackPort());
        this.connectFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(final ChannelFuture connectFuture) {
                if (connectFuture.isSuccess()) {
                    log.debug("{} connected; waiting for TLS handshake.", (Object)feedbackConnection.name);
                    SslHandler sslHandler = (SslHandler)connectFuture.channel().pipeline().get(SslHandler.class);
                    try {
                        sslHandler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                            public void operationComplete(Future<Channel> handshakeFuture) {
                                if (handshakeFuture.isSuccess()) {
                                    log.debug("{} successfully completed TLS handshake.", (Object)feedbackConnection.name);
                                    feedbackConnection.handshakeCompleted = true;
                                    if (feedbackConnection.listener != null) {
                                        feedbackConnection.listener.handleConnectionSuccess(feedbackConnection);
                                    }
                                } else {
                                    log.debug("{} failed to complete TLS handshake with APNs feedback service.", (Object)feedbackConnection.name, (Object)handshakeFuture.cause());
                                    connectFuture.channel().close();
                                    if (feedbackConnection.listener != null) {
                                        feedbackConnection.listener.handleConnectionFailure(feedbackConnection, handshakeFuture.cause());
                                    }
                                }
                            }
                        });
                    }
                    catch (NullPointerException e) {
                        log.warn("{} failed to get SSL handler and could not wait for a TLS handshake.", (Object)feedbackConnection.name);
                        connectFuture.channel().close();
                        if (feedbackConnection.listener != null) {
                            feedbackConnection.listener.handleConnectionFailure(feedbackConnection, e);
                        }
                    }
                } else {
                    log.debug("{} failed to connect to APNs feedback service.", (Object)feedbackConnection.name, (Object)connectFuture.cause());
                    if (feedbackConnection.listener != null) {
                        feedbackConnection.listener.handleConnectionFailure(feedbackConnection, connectFuture.cause());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownImmediately() {
        if (this.connectFuture != null) {
            Object object = this.channelRegistrationMonitor;
            synchronized (object) {
                if (this.connectFuture.channel().isRegistered()) {
                    this.connectFuture.channel().eventLoop().execute(this.getImmediateShutdownRunnable());
                } else {
                    this.closeOnRegistration = true;
                }
            }
        }
    }

    private Runnable getImmediateShutdownRunnable() {
        final FeedbackServiceConnection feedbackConnection = this;
        return new Runnable(){

            @Override
            public void run() {
                SslHandler sslHandler = (SslHandler)feedbackConnection.connectFuture.channel().pipeline().get(SslHandler.class);
                if (feedbackConnection.connectFuture.isCancellable()) {
                    feedbackConnection.connectFuture.cancel(true);
                } else if (sslHandler != null && sslHandler.handshakeFuture().isCancellable()) {
                    sslHandler.handshakeFuture().cancel(true);
                } else {
                    feedbackConnection.connectFuture.channel().close();
                }
            }
        };
    }

    public String toString() {
        return "FeedbackServiceConnection [name=" + this.name + "]";
    }

    private class FeedbackClientHandler
    extends SimpleChannelInboundHandler<ExpiredToken> {
        private final FeedbackServiceConnection feedbackClient;

        public FeedbackClientHandler(FeedbackServiceConnection feedbackClient) {
            this.feedbackClient = feedbackClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRegistered(ChannelHandlerContext context) throws Exception {
            super.channelRegistered(context);
            Object object = this.feedbackClient.channelRegistrationMonitor;
            synchronized (object) {
                if (this.feedbackClient.closeOnRegistration) {
                    log.debug("Channel registered for {}, but shutting down immediately.", (Object)this.feedbackClient.name);
                    context.channel().eventLoop().execute(this.feedbackClient.getImmediateShutdownRunnable());
                }
            }
        }

        protected void channelRead0(ChannelHandlerContext context, ExpiredToken expiredToken) {
            if (this.feedbackClient.listener != null) {
                this.feedbackClient.listener.handleExpiredToken(this.feedbackClient, expiredToken);
            }
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
            if (!(cause instanceof ReadTimeoutException)) {
                log.debug("Caught an unexpected exception while waiting for expired tokens.", cause);
            }
            context.close();
        }

        public void channelInactive(ChannelHandlerContext context) throws Exception {
            super.channelInactive(context);
            if (this.feedbackClient.handshakeCompleted && this.feedbackClient.listener != null) {
                this.feedbackClient.listener.handleConnectionClosure(this.feedbackClient);
            }
        }
    }

    private class ExpiredTokenDecoder
    extends ReplayingDecoder<ExpiredTokenDecoderState> {
        private Date expiration;
        private byte[] token;

        public ExpiredTokenDecoder() {
            super((Object)ExpiredTokenDecoderState.EXPIRATION);
        }

        protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
            switch ((ExpiredTokenDecoderState)((Object)this.state())) {
                case EXPIRATION: {
                    long timestamp = ((long)in.readInt() & 0xFFFFFFFFL) * 1000L;
                    this.expiration = new Date(timestamp);
                    this.checkpoint((Object)ExpiredTokenDecoderState.TOKEN_LENGTH);
                    break;
                }
                case TOKEN_LENGTH: {
                    this.token = new byte[in.readShort() & 0xFFFF];
                    this.checkpoint((Object)ExpiredTokenDecoderState.TOKEN);
                    break;
                }
                case TOKEN: {
                    in.readBytes(this.token);
                    out.add(new ExpiredToken(this.token, this.expiration));
                    this.checkpoint((Object)ExpiredTokenDecoderState.EXPIRATION);
                }
            }
        }
    }

    private static enum ExpiredTokenDecoderState {
        EXPIRATION,
        TOKEN_LENGTH,
        TOKEN;

    }
}

