/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.relayrides.pushy.apns.ApnsConnectionConfiguration;
import com.relayrides.pushy.apns.ApnsConnectionListener;
import com.relayrides.pushy.apns.ApnsEnvironment;
import com.relayrides.pushy.apns.ApnsPushNotification;
import com.relayrides.pushy.apns.DeliveryPriority;
import com.relayrides.pushy.apns.KnownBadPushNotification;
import com.relayrides.pushy.apns.RejectedNotification;
import com.relayrides.pushy.apns.RejectedNotificationReason;
import com.relayrides.pushy.apns.SendableApnsPushNotification;
import com.relayrides.pushy.apns.SentNotificationBuffer;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApnsConnection<T extends ApnsPushNotification> {
    private final ApnsEnvironment environment;
    private final SSLContext sslContext;
    private final NioEventLoopGroup eventLoopGroup;
    private final ApnsConnectionConfiguration configuration;
    private final ApnsConnectionListener<T> listener;
    private final String name;
    private final Object channelRegistrationMonitor = new Object();
    private ChannelFuture connectFuture;
    private volatile boolean handshakeCompleted = false;
    private volatile boolean closeOnRegistration;
    private int sequenceNumber = 1;
    private final Object pendingWriteMonitor = new Object();
    private int pendingWriteCount = 0;
    private int sendAttempts = 0;
    private SendableApnsPushNotification<KnownBadPushNotification> shutdownNotification;
    private boolean rejectionReceived = false;
    private final SentNotificationBuffer<T> sentNotificationBuffer;
    private static final String PIPELINE_MAIN_HANDLER = "handler";
    private static final String PIPELINE_IDLE_STATE_HANDLER = "idleStateHandler";
    private static final String PIPELINE_GRACEFUL_SHUTDOWN_TIMEOUT_HANDLER = "gracefulShutdownTimeoutHandler";
    private static final Logger log = LoggerFactory.getLogger(ApnsConnection.class);
    public static final int DEFAULT_SENT_NOTIFICATION_BUFFER_CAPACITY = 8192;

    public ApnsConnection(ApnsEnvironment environment, SSLContext sslContext, NioEventLoopGroup eventLoopGroup, ApnsConnectionConfiguration configuration, ApnsConnectionListener<T> listener, String name) {
        if (environment == null) {
            throw new NullPointerException("Environment must not be null.");
        }
        this.environment = environment;
        if (sslContext == null) {
            throw new NullPointerException("SSL context must not be null.");
        }
        this.sslContext = sslContext;
        if (eventLoopGroup == null) {
            throw new NullPointerException("Event loop group must not be null.");
        }
        this.eventLoopGroup = eventLoopGroup;
        if (configuration == null) {
            throw new NullPointerException("Connection configuration must not be null.");
        }
        this.configuration = configuration;
        this.listener = listener;
        if (name == null) {
            throw new NullPointerException("Connection name must not be null.");
        }
        this.name = name;
        this.sentNotificationBuffer = new SentNotificationBuffer(configuration.getSentNotificationBufferCapacity());
    }

    public synchronized void connect() {
        final ApnsConnection apnsConnection = this;
        if (this.connectFuture != null) {
            throw new IllegalStateException(String.format("%s already started a connection attempt.", this.name));
        }
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)this.eventLoopGroup);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        bootstrap.option(ChannelOption.AUTO_CLOSE, (Object)false);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) {
                ChannelPipeline pipeline = channel.pipeline();
                SSLEngine sslEngine = apnsConnection.sslContext.createSSLEngine();
                sslEngine.setUseClientMode(true);
                pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                pipeline.addLast("decoder", (ChannelHandler)new RejectedNotificationDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new ApnsPushNotificationEncoder());
                pipeline.addLast(ApnsConnection.PIPELINE_MAIN_HANDLER, (ChannelHandler)new ApnsConnectionHandler(apnsConnection));
            }
        });
        log.debug("{} beginning connection process.", (Object)apnsConnection.name);
        this.connectFuture = bootstrap.connect(this.environment.getApnsGatewayHost(), this.environment.getApnsGatewayPort());
        this.connectFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(final ChannelFuture connectFuture) {
                if (connectFuture.isSuccess()) {
                    log.debug("{} connected; waiting for TLS handshake.", (Object)apnsConnection.name);
                    SslHandler sslHandler = (SslHandler)connectFuture.channel().pipeline().get(SslHandler.class);
                    try {
                        sslHandler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                            public void operationComplete(Future<Channel> handshakeFuture) {
                                if (handshakeFuture.isSuccess()) {
                                    log.debug("{} successfully completed TLS handshake.", (Object)apnsConnection.name);
                                    apnsConnection.handshakeCompleted = true;
                                    if (apnsConnection.listener != null) {
                                        apnsConnection.listener.handleConnectionSuccess(apnsConnection);
                                    }
                                    if (apnsConnection.configuration.getCloseAfterInactivityTime() != null) {
                                        connectFuture.channel().pipeline().addBefore(ApnsConnection.PIPELINE_MAIN_HANDLER, ApnsConnection.PIPELINE_IDLE_STATE_HANDLER, (ChannelHandler)new IdleStateHandler(0, 0, apnsConnection.configuration.getCloseAfterInactivityTime().intValue()));
                                    }
                                } else {
                                    log.debug("{} failed to complete TLS handshake with APNs gateway.", (Object)apnsConnection.name, (Object)handshakeFuture.cause());
                                    connectFuture.channel().close();
                                    if (apnsConnection.listener != null) {
                                        apnsConnection.listener.handleConnectionFailure(apnsConnection, handshakeFuture.cause());
                                    }
                                }
                            }
                        });
                    }
                    catch (NullPointerException e) {
                        log.warn("{} failed to get SSL handler and could not wait for a TLS handshake.", (Object)apnsConnection.name);
                        connectFuture.channel().close();
                        if (apnsConnection.listener != null) {
                            apnsConnection.listener.handleConnectionFailure(apnsConnection, e);
                        }
                    }
                } else {
                    log.debug("{} failed to connect to APNs gateway.", (Object)apnsConnection.name, (Object)connectFuture.cause());
                    if (apnsConnection.listener != null) {
                        apnsConnection.listener.handleConnectionFailure(apnsConnection, connectFuture.cause());
                    }
                }
            }
        });
    }

    public synchronized void sendNotification(T notification) {
        ApnsConnection apnsConnection = this;
        if (!this.handshakeCompleted) {
            throw new IllegalStateException(String.format("%s has not completed handshake.", this.name));
        }
        if (this.shutdownNotification == null) {
            this.connectFuture.channel().eventLoop().execute(new Runnable((ApnsPushNotification)notification, apnsConnection){
                final /* synthetic */ ApnsPushNotification val$notification;
                final /* synthetic */ ApnsConnection val$apnsConnection;
                {
                    this.val$notification = apnsPushNotification;
                    this.val$apnsConnection = apnsConnection2;
                }

                @Override
                public void run() {
                    final SendableApnsPushNotification<ApnsPushNotification> sendableNotification = new SendableApnsPushNotification<ApnsPushNotification>(this.val$notification, this.val$apnsConnection.sequenceNumber++);
                    log.trace("{} sending {}", (Object)this.val$apnsConnection.name, sendableNotification);
                    this.val$apnsConnection.pendingWriteCount += 1;
                    this.val$apnsConnection.connectFuture.channel().writeAndFlush(sendableNotification).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void operationComplete(ChannelFuture writeFuture) {
                            if (writeFuture.isSuccess()) {
                                log.trace("{} successfully wrote notification {}", (Object)val$apnsConnection.name, (Object)sendableNotification.getSequenceNumber());
                                if (val$apnsConnection.rejectionReceived) {
                                    if (val$apnsConnection.listener != null) {
                                        val$apnsConnection.listener.handleUnprocessedNotifications(val$apnsConnection, Collections.singletonList(val$notification));
                                    }
                                } else {
                                    val$apnsConnection.sentNotificationBuffer.addSentNotification(sendableNotification);
                                }
                            } else {
                                log.trace("{} failed to write notification {}", new Object[]{val$apnsConnection.name, sendableNotification, writeFuture.cause()});
                                if (val$apnsConnection.listener != null) {
                                    val$apnsConnection.listener.handleWriteFailure(val$apnsConnection, val$notification, writeFuture.cause());
                                }
                            }
                            val$apnsConnection.pendingWriteCount -= 1;
                            assert (val$apnsConnection.pendingWriteCount >= 0);
                            if (val$apnsConnection.pendingWriteCount == 0) {
                                Object object = val$apnsConnection.pendingWriteMonitor;
                                synchronized (object) {
                                    val$apnsConnection.pendingWriteMonitor.notifyAll();
                                }
                            }
                        }
                    });
                }
            });
        } else if (this.listener != null) {
            this.listener.handleWriteFailure(this, notification, new IllegalStateException("Connection is shutting down."));
        }
        if (this.configuration.getSendAttemptLimit() != null && ++this.sendAttempts >= this.configuration.getSendAttemptLimit()) {
            log.debug("{} reached send attempt limit and will shut down gracefully.", (Object)this.name);
            this.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPendingWritesToFinish() throws InterruptedException {
        Object object = this.pendingWriteMonitor;
        synchronized (object) {
            while (this.pendingWriteCount > 0) {
                this.pendingWriteMonitor.wait();
            }
        }
    }

    public synchronized void shutdownGracefully() {
        if (this.connectFuture != null && this.connectFuture.channel() != null && this.connectFuture.channel().pipeline().get(PIPELINE_IDLE_STATE_HANDLER) != null) {
            this.connectFuture.channel().pipeline().remove(PIPELINE_IDLE_STATE_HANDLER);
        }
        final ApnsConnection apnsConnection = this;
        if (this.handshakeCompleted && this.connectFuture.channel().isActive()) {
            this.connectFuture.channel().eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    if (apnsConnection.shutdownNotification == null) {
                        log.debug("{} sending known-bad notification to shut down.", (Object)apnsConnection.name);
                        apnsConnection.shutdownNotification = new SendableApnsPushNotification<KnownBadPushNotification>(new KnownBadPushNotification(), apnsConnection.sequenceNumber++);
                        if (apnsConnection.configuration.getGracefulShutdownTimeout() != null && apnsConnection.connectFuture.channel().pipeline().get(ApnsConnection.PIPELINE_GRACEFUL_SHUTDOWN_TIMEOUT_HANDLER) == null) {
                            apnsConnection.connectFuture.channel().pipeline().addBefore(ApnsConnection.PIPELINE_MAIN_HANDLER, ApnsConnection.PIPELINE_GRACEFUL_SHUTDOWN_TIMEOUT_HANDLER, (ChannelHandler)new IdleStateHandler(apnsConnection.configuration.getGracefulShutdownTimeout().intValue(), 0, 0));
                        }
                        apnsConnection.pendingWriteCount += 1;
                        apnsConnection.connectFuture.channel().writeAndFlush((Object)apnsConnection.shutdownNotification).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void operationComplete(ChannelFuture future) {
                                if (future.isSuccess()) {
                                    log.trace("{} successfully wrote known-bad notification {}", (Object)apnsConnection.name, (Object)apnsConnection.shutdownNotification.getSequenceNumber());
                                } else {
                                    log.trace("{} failed to write known-bad notification {}", new Object[]{apnsConnection.name, apnsConnection.shutdownNotification, future.cause()});
                                    apnsConnection.shutdownNotification = null;
                                    apnsConnection.shutdownGracefully();
                                }
                                apnsConnection.pendingWriteCount -= 1;
                                assert (apnsConnection.pendingWriteCount >= 0);
                                if (apnsConnection.pendingWriteCount == 0) {
                                    Object object = apnsConnection.pendingWriteMonitor;
                                    synchronized (object) {
                                        apnsConnection.pendingWriteMonitor.notifyAll();
                                    }
                                }
                            }
                        });
                    }
                }
            });
        } else {
            this.shutdownImmediately();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownImmediately() {
        if (this.connectFuture != null) {
            Object object = this.channelRegistrationMonitor;
            synchronized (object) {
                if (this.connectFuture.channel().isRegistered()) {
                    this.connectFuture.channel().eventLoop().execute(this.getImmediateShutdownRunnable());
                } else {
                    this.closeOnRegistration = true;
                }
            }
        }
    }

    private Runnable getImmediateShutdownRunnable() {
        final ApnsConnection apnsConnection = this;
        return new Runnable(){

            @Override
            public void run() {
                SslHandler sslHandler = (SslHandler)apnsConnection.connectFuture.channel().pipeline().get(SslHandler.class);
                if (apnsConnection.connectFuture.isCancellable()) {
                    apnsConnection.connectFuture.cancel(true);
                } else if (sslHandler != null && sslHandler.handshakeFuture().isCancellable()) {
                    sslHandler.handshakeFuture().cancel(true);
                } else {
                    apnsConnection.connectFuture.channel().close();
                }
            }
        };
    }

    public String toString() {
        return "ApnsConnection [name=" + this.name + "]";
    }

    private class ApnsConnectionHandler
    extends SimpleChannelInboundHandler<RejectedNotification> {
        private final ApnsConnection<T> apnsConnection;

        public ApnsConnectionHandler(ApnsConnection<T> apnsConnection2) {
            this.apnsConnection = apnsConnection2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRegistered(ChannelHandlerContext context) throws Exception {
            super.channelRegistered(context);
            Object object = this.apnsConnection.channelRegistrationMonitor;
            synchronized (object) {
                if (this.apnsConnection.closeOnRegistration) {
                    log.debug("Channel registered for {}, but shutting down immediately.", (Object)this.apnsConnection.name);
                    context.channel().eventLoop().execute(this.apnsConnection.getImmediateShutdownRunnable());
                }
            }
        }

        protected void channelRead0(ChannelHandlerContext context, RejectedNotification rejectedNotification) {
            List unprocessedNotifications;
            boolean isKnownBadRejection;
            log.debug("APNs gateway rejected notification with sequence number {} from {} ({}).", new Object[]{rejectedNotification.getSequenceNumber(), this.apnsConnection.name, rejectedNotification.getReason()});
            this.apnsConnection.rejectionReceived = true;
            this.apnsConnection.sentNotificationBuffer.clearNotificationsBeforeSequenceNumber(rejectedNotification.getSequenceNumber());
            boolean bl = isKnownBadRejection = this.apnsConnection.shutdownNotification != null && rejectedNotification.getSequenceNumber() == this.apnsConnection.shutdownNotification.getSequenceNumber();
            if (!isKnownBadRejection && !RejectedNotificationReason.SHUTDOWN.equals((Object)rejectedNotification.getReason())) {
                Object notification = this.apnsConnection.sentNotificationBuffer.getNotificationWithSequenceNumber(rejectedNotification.getSequenceNumber());
                if (notification != null) {
                    if (this.apnsConnection.listener != null) {
                        this.apnsConnection.listener.handleRejectedNotification(this.apnsConnection, notification, rejectedNotification.getReason());
                    }
                } else {
                    log.error("{} failed to find rejected notification with sequence number {} (buffer has range {} to {}); this may mean the sent notification buffer is too small. Please report this as a bug.", new Object[]{this.apnsConnection.name, rejectedNotification.getSequenceNumber(), this.apnsConnection.sentNotificationBuffer.getLowestSequenceNumber(), this.apnsConnection.sentNotificationBuffer.getHighestSequenceNumber()});
                }
            }
            if (!(unprocessedNotifications = this.apnsConnection.sentNotificationBuffer.getAllNotificationsAfterSequenceNumber(rejectedNotification.getSequenceNumber())).isEmpty() && this.apnsConnection.listener != null) {
                this.apnsConnection.listener.handleUnprocessedNotifications(this.apnsConnection, unprocessedNotifications);
            }
            this.apnsConnection.sentNotificationBuffer.clearAllNotifications();
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
            log.debug("{} caught an exception.", (Object)this.apnsConnection.name, (Object)cause);
        }

        public void channelInactive(ChannelHandlerContext context) throws Exception {
            super.channelInactive(context);
            if (this.apnsConnection.handshakeCompleted && this.apnsConnection.listener != null) {
                this.apnsConnection.listener.handleConnectionClosure(this.apnsConnection);
            }
        }

        public void channelWritabilityChanged(ChannelHandlerContext context) throws Exception {
            super.channelWritabilityChanged(context);
            if (this.apnsConnection.listener != null) {
                this.apnsConnection.listener.handleConnectionWritabilityChange(this.apnsConnection, context.channel().isWritable());
            }
        }

        public void userEventTriggered(ChannelHandlerContext context, Object event) throws Exception {
            if (event instanceof IdleStateEvent) {
                if (this.apnsConnection.shutdownNotification == null) {
                    log.debug("{} will shut down gracefully due to inactivity.", (Object)this.apnsConnection.name);
                    this.apnsConnection.shutdownGracefully();
                } else {
                    log.debug("Graceful shutdown attempt for {} timed out; shutting down immediately.", (Object)this.apnsConnection.name);
                    this.apnsConnection.shutdownImmediately();
                }
            } else {
                super.userEventTriggered(context, event);
            }
        }
    }

    private class ApnsPushNotificationEncoder
    extends MessageToByteEncoder<SendableApnsPushNotification<T>> {
        private static final byte BINARY_PUSH_NOTIFICATION_COMMAND = 2;
        private static final int INVALIDATE_IMMEDIATELY = 0;
        private static final int FRAME_ITEM_ID_SIZE = 1;
        private static final int FRAME_ITEM_LENGTH_SIZE = 2;
        private static final short SEQUENCE_NUMBER_SIZE = 4;
        private static final short DELIVERY_INVALIDATION_TIME_SIZE = 4;
        private static final short PRIORITY_SIZE = 1;
        private final Charset utf8 = Charset.forName("UTF-8");

        private ApnsPushNotificationEncoder() {
        }

        protected void encode(ChannelHandlerContext context, SendableApnsPushNotification<T> sendablePushNotification, ByteBuf out) throws Exception {
            out.writeByte(2);
            out.writeInt(this.getFrameLength(sendablePushNotification));
            out.writeByte((int)ApnsFrameItem.SEQUENCE_NUMBER.getCode());
            out.writeShort(4);
            out.writeInt(sendablePushNotification.getSequenceNumber());
            out.writeByte((int)ApnsFrameItem.DEVICE_TOKEN.getCode());
            out.writeShort(sendablePushNotification.getPushNotification().getToken().length);
            out.writeBytes(sendablePushNotification.getPushNotification().getToken());
            byte[] payloadBytes = sendablePushNotification.getPushNotification().getPayload().getBytes(this.utf8);
            out.writeByte((int)ApnsFrameItem.PAYLOAD.getCode());
            out.writeShort(payloadBytes.length);
            out.writeBytes(payloadBytes);
            out.writeByte((int)ApnsFrameItem.DELIVERY_INVALIDATION_TIME.getCode());
            out.writeShort(4);
            int deliveryInvalidationTime = sendablePushNotification.getPushNotification().getDeliveryInvalidationTime() != null ? this.getTimestampInSeconds(sendablePushNotification.getPushNotification().getDeliveryInvalidationTime()) : 0;
            out.writeInt(deliveryInvalidationTime);
            DeliveryPriority priority = sendablePushNotification.getPushNotification().getPriority() != null ? sendablePushNotification.getPushNotification().getPriority() : DeliveryPriority.IMMEDIATE;
            out.writeByte((int)ApnsFrameItem.PRIORITY.getCode());
            out.writeShort(1);
            out.writeByte((int)priority.getCode());
        }

        private int getTimestampInSeconds(Date date) {
            return (int)(date.getTime() / 1000L);
        }

        private int getFrameLength(SendableApnsPushNotification<T> sendableApnsPushNotification) {
            return ApnsFrameItem.values().length * 3 + sendableApnsPushNotification.getPushNotification().getToken().length + sendableApnsPushNotification.getPushNotification().getPayload().getBytes(this.utf8).length + 4 + 4 + 1;
        }
    }

    private class RejectedNotificationDecoder
    extends ByteToMessageDecoder {
        private static final int EXPECTED_BYTES = 6;
        private static final byte EXPECTED_COMMAND = 8;

        private RejectedNotificationDecoder() {
        }

        protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
            if (in.readableBytes() >= 6) {
                byte command = in.readByte();
                byte code = in.readByte();
                int notificationId = in.readInt();
                if (command != 8) {
                    log.error("Unexpected command: {}", (Object)command);
                }
                RejectedNotificationReason errorCode = RejectedNotificationReason.getByErrorCode(code);
                out.add(new RejectedNotification(notificationId, errorCode));
            }
        }
    }

    protected static enum ApnsFrameItem {
        DEVICE_TOKEN(1),
        PAYLOAD(2),
        SEQUENCE_NUMBER(3),
        DELIVERY_INVALIDATION_TIME(4),
        PRIORITY(5);

        private final byte code;

        private ApnsFrameItem(byte code) {
            this.code = code;
        }

        protected byte getCode() {
            return this.code;
        }

        protected static ApnsFrameItem getFrameItemFromCode(byte code) {
            for (ApnsFrameItem item : ApnsFrameItem.values()) {
                if (item.getCode() != code) continue;
                return item;
            }
            throw new IllegalArgumentException(String.format("No frame item found with code %d", code));
        }
    }
}

