/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSElementDeclHelper;
import org.apache.xerces.impl.xs.XSOpenContentDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.models.XS11CMRestriction;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSObject;

public class XS11AllCM
implements XSCMValidator,
XS11CMRestriction.XS11CM {
    private static final short STATE_START = 0;
    private static final short STATE_CHILD = 1;
    private static final short STATE_SUFFIX = 2;
    private final boolean fHasOptionalContent;
    private final XSElementDecl[] fElements;
    private final XSWildcardDecl[] fWildcards;
    private final int[] fMinOccurs;
    private final int[] fMaxOccurs;
    private final int fNumElements;
    private final int fNumTotal;
    private final XSOpenContentDecl fOpenContent;

    public XS11AllCM(boolean hasOptionalContent, int size, XSParticleDecl[] particles, XSOpenContentDecl openContent) {
        this.fHasOptionalContent = hasOptionalContent;
        int numE = 1;
        for (int i = 0; i < size; ++i) {
            if (particles[i].fType != 1) continue;
            ++numE;
        }
        this.fNumElements = numE;
        this.fNumTotal = size + 1;
        this.fElements = numE > 1 ? new XSElementDecl[numE] : null;
        this.fWildcards = this.fNumTotal > numE ? new XSWildcardDecl[this.fNumTotal] : null;
        if (this.fNumTotal > 1) {
            this.fMinOccurs = new int[this.fNumTotal];
            this.fMaxOccurs = new int[this.fNumTotal];
        } else {
            this.fMinOccurs = null;
            this.fMaxOccurs = null;
        }
        int numW = numE;
        numE = 1;
        for (int i = 0; i < size; ++i) {
            XSParticleDecl particle = particles[i];
            if (particle.fType == 1) {
                this.fElements[numE] = (XSElementDecl)particle.fValue;
                this.fMinOccurs[numE] = particle.fMinOccurs;
                this.fMaxOccurs[numE] = particle.fMaxOccurs;
                ++numE;
                continue;
            }
            this.fWildcards[numW] = (XSWildcardDecl)particle.fValue;
            this.fMinOccurs[numW] = particle.fMinOccurs;
            this.fMaxOccurs[numW] = particle.fMaxOccurs;
            ++numW;
        }
        this.fOpenContent = openContent;
    }

    @Override
    public int[] startContentModel() {
        int[] state = new int[this.fNumTotal];
        for (int i = 0; i < this.fNumTotal; ++i) {
            state[i] = 0;
        }
        return state;
    }

    Object findMatchingDecl(QName elementName, SubstitutionGroupHandler subGroupHandler) {
        XSElementDecl matchingDecl = this.findMatchingElemDecl(elementName, subGroupHandler);
        if (matchingDecl != null) {
            return matchingDecl;
        }
        for (int i = this.fNumElements; i < this.fNumTotal; ++i) {
            if (!this.fWildcards[i].allowQName(elementName)) continue;
            return this.fWildcards[i];
        }
        return null;
    }

    @Override
    public XSElementDecl findMatchingElemDecl(QName elementName, SubstitutionGroupHandler subGroupHandler) {
        for (int i = 1; i < this.fNumElements; ++i) {
            XSElementDecl matchingDecl = subGroupHandler.getMatchingElemDecl(elementName, this.fElements[i], (short)4);
            if (matchingDecl == null) continue;
            return matchingDecl;
        }
        return null;
    }

    @Override
    public boolean allowExpandedName(XSWildcardDecl wildcard, QName curElem, SubstitutionGroupHandler subGroupHandler, XSElementDeclHelper eDeclHelper) {
        if (wildcard.allowQName(curElem)) {
            if (wildcard.fDisallowedSibling && this.findMatchingElemDecl(curElem, subGroupHandler) != null) {
                return false;
            }
            return !wildcard.fDisallowedDefined || eDeclHelper.getGlobalElementDecl(curElem) == null;
        }
        return false;
    }

    @Override
    public Object oneTransition(QName elementName, int[] currentState, SubstitutionGroupHandler subGroupHandler, XSElementDeclHelper eDeclHelper) {
        int i;
        if (currentState[0] < 0) {
            currentState[0] = -2;
            return this.findMatchingDecl(elementName, subGroupHandler);
        }
        if (currentState[0] == 2) {
            if (this.allowExpandedName(this.fOpenContent.fWildcard, elementName, subGroupHandler, eDeclHelper)) {
                return this.fOpenContent;
            }
            currentState[0] = -1;
            return this.findMatchingDecl(elementName, subGroupHandler);
        }
        currentState[0] = 1;
        for (i = 1; i < this.fNumElements; ++i) {
            XSElementDecl matchingDecl;
            if (currentState[i] == this.fMaxOccurs[i] || (matchingDecl = subGroupHandler.getMatchingElemDecl(elementName, this.fElements[i], (short)4)) == null) continue;
            int n = i;
            currentState[n] = currentState[n] + 1;
            return matchingDecl;
        }
        for (i = this.fNumElements; i < this.fNumTotal; ++i) {
            if (currentState[i] == this.fMaxOccurs[i] || !this.allowExpandedName(this.fWildcards[i], elementName, subGroupHandler, eDeclHelper)) continue;
            int n = i;
            currentState[n] = currentState[n] + 1;
            return this.fWildcards[i];
        }
        if (this.fOpenContent != null) {
            if (this.fOpenContent.fMode == 2) {
                if (this.isFinal(currentState)) {
                    currentState[0] = 2;
                } else {
                    currentState[0] = -1;
                    return this.findMatchingDecl(elementName, subGroupHandler);
                }
            }
            if (this.allowExpandedName(this.fOpenContent.fWildcard, elementName, subGroupHandler, eDeclHelper)) {
                return this.fOpenContent;
            }
        }
        currentState[0] = -1;
        return this.findMatchingDecl(elementName, subGroupHandler);
    }

    @Override
    public boolean endContentModel(int[] currentState) {
        int state = currentState[0];
        if (state == -1 || state == -2) {
            return false;
        }
        return this.isFinal(currentState);
    }

    @Override
    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler subGroupHandler, XSConstraints xsConstraints) throws XMLSchemaException {
        int j;
        int i;
        for (i = 1; i < this.fNumElements; ++i) {
            for (j = i + 1; j < this.fNumElements; ++j) {
                if (!xsConstraints.overlapUPA((Object)this.fElements[i], (Object)this.fElements[j], subGroupHandler)) continue;
                throw new XMLSchemaException("cos-nonambig", new Object[]{this.fElements[i].toString(), this.fElements[j].toString()});
            }
        }
        for (i = this.fNumElements; i < this.fNumTotal; ++i) {
            for (j = i + 1; j < this.fNumTotal; ++j) {
                if (!xsConstraints.overlapUPA(this.fWildcards[i], this.fWildcards[j])) continue;
                throw new XMLSchemaException("cos-nonambig", new Object[]{this.fWildcards[i].toString(), this.fWildcards[j].toString()});
            }
        }
        return false;
    }

    @Override
    public Vector whatCanGoHere(int[] state) {
        int i;
        Vector<XSObject> ret = new Vector<XSObject>();
        for (i = 1; i < this.fNumElements; ++i) {
            if (state[i] != 0 && state[i] >= this.fMaxOccurs[i]) continue;
            ret.addElement(this.fElements[i]);
        }
        if (ret.size() == 0) {
            for (i = this.fNumElements; i < this.fNumTotal; ++i) {
                if (state[i] != 0 && state[i] >= this.fMaxOccurs[i]) continue;
                ret.addElement(this.fWildcards[i]);
            }
        }
        if (ret.size() == 0 && this.fOpenContent != null) {
            ret.add(this.fOpenContent);
        }
        return ret;
    }

    @Override
    public int[] occurenceInfo(int[] state) {
        return null;
    }

    @Override
    public String getTermName(int termId) {
        return null;
    }

    @Override
    public boolean isCompactedForUPA() {
        return false;
    }

    private boolean isFinal(int[] currentState) {
        if (this.fHasOptionalContent && currentState[0] == 0 || currentState[0] == 2) {
            return true;
        }
        for (int i = 1; i < this.fNumTotal; ++i) {
            if (currentState[i] >= this.fMinOccurs[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public XSElementDecl nextElementTransition(int[] s, int[] sn, int[] index) {
        int idx;
        int n = idx = index[0] == -1 ? 1 : index[0] + 1;
        while (idx < this.fNumElements) {
            if (this.isAllowedTransition(s, sn, idx)) {
                index[0] = idx;
                return this.fElements[idx];
            }
            ++idx;
        }
        index[0] = -1;
        return null;
    }

    @Override
    public XSWildcardDecl nextWildcardTransition(int[] s, int[] sn, int[] index) {
        int idx;
        int n = idx = index[0] == -1 ? this.fNumElements : index[0] + 1;
        while (idx < this.fNumTotal) {
            if (this.isAllowedTransition(s, sn, idx)) {
                index[0] = idx;
                return this.fWildcards[idx];
            }
            ++idx;
        }
        if (idx == this.fNumTotal && this.isOpenContentAllowed(s, sn)) {
            index[0] = this.fNumTotal;
            return this.fOpenContent.fWildcard;
        }
        index[0] = -1;
        return null;
    }

    private boolean isAllowedTransition(int[] s, int[] sn, int index) {
        if (s[0] == 2) {
            return false;
        }
        if (s[index] == this.fMaxOccurs[index]) {
            return false;
        }
        if (sn != null) {
            System.arraycopy(s, 0, sn, 0, s.length);
            sn[0] = 1;
            if (sn[index] == 0 || sn[index] < this.fMinOccurs[index] || this.fMaxOccurs[index] != -1) {
                int n = index;
                sn[n] = sn[n] + 1;
            }
        }
        return true;
    }

    private boolean isOpenContentAllowed(int[] s, int[] sn) {
        if (this.fOpenContent == null) {
            return false;
        }
        if (this.fOpenContent.fMode == 2) {
            if (this.isFinal(s)) {
                sn[0] = 2;
                return true;
            }
            return false;
        }
        System.arraycopy(s, 0, sn, 0, s.length);
        return true;
    }

    @Override
    public boolean isOpenContent(XSWildcardDecl w) {
        return this.fOpenContent != null && this.fOpenContent.fWildcard == w;
    }

    @Override
    public List getDefinedNames(SubstitutionGroupHandler subGroupHandler) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 1; i < this.fNumElements; ++i) {
            XSElementDecl e = this.fElements[i];
            ret.add(e.fTargetNamespace);
            ret.add(e.fName);
            if (e.fScope != 1) continue;
            XSElementDecl[] es = subGroupHandler.getSubstitutionGroup(e, (short)4);
            for (int j = 0; j < es.length; ++j) {
                ret.add(es[j].fTargetNamespace);
                ret.add(es[j].fName);
            }
        }
        return ret;
    }

    @Override
    public void optimizeStates(XS11CMRestriction.XS11CM base, int[] b, int[] d, int indexb) {
    }

    private XS11AllCM(boolean hasOptionalContent, XSElementDecl[] elements, XSWildcardDecl[] wildcards, int[] minOccurs, int[] maxOccurs, int numElements, int numTotal, XSOpenContentDecl openContent) {
        this.fHasOptionalContent = hasOptionalContent;
        this.fElements = elements;
        this.fWildcards = wildcards;
        this.fMinOccurs = minOccurs;
        this.fMaxOccurs = maxOccurs;
        this.fNumElements = numElements;
        this.fNumTotal = numTotal;
        this.fOpenContent = openContent;
    }

    XS11AllCM copy() {
        int[] maxOccurs;
        int[] minOccurs;
        if (this.fNumTotal > 1) {
            minOccurs = new int[this.fNumTotal];
            maxOccurs = new int[this.fNumTotal];
            System.arraycopy(this.fMinOccurs, 0, minOccurs, 0, this.fNumTotal);
            System.arraycopy(this.fMaxOccurs, 0, maxOccurs, 0, this.fNumTotal);
        } else {
            minOccurs = null;
            maxOccurs = null;
        }
        return new XS11AllCM(this.fHasOptionalContent, this.fElements, this.fWildcards, minOccurs, maxOccurs, this.fNumElements, this.fNumTotal, this.fOpenContent);
    }

    void collectOccurs(int[] min, int[] max, int b, int d) {
        int n = b;
        min[n] = min[n] + this.fMinOccurs[d];
        if (max[b] != -1) {
            if (this.fMaxOccurs[d] == -1) {
                max[b] = -1;
            } else {
                int n2 = b;
                max[n2] = max[n2] + this.fMaxOccurs[d];
            }
        }
    }

    boolean removeAsBase(int[] min, int[] max, int[] used) {
        for (int i = 1; i < this.fNumElements; ++i) {
            if (this.fMinOccurs[i] > min[i]) {
                return false;
            }
            this.fMinOccurs[i] = 0;
            if (this.fMaxOccurs[i] != -1) {
                if (max[i] == -1 || this.fMaxOccurs[i] < max[i]) {
                    if (used[i] > 1) {
                        used[i] = -1;
                        continue;
                    }
                    if (max[i] != -1) {
                        int n = i;
                        max[n] = max[n] - this.fMaxOccurs[i];
                    }
                    this.fMaxOccurs[i] = 0;
                    continue;
                }
                int n = i;
                this.fMaxOccurs[n] = this.fMaxOccurs[n] - max[i];
                max[i] = 0;
                continue;
            }
            if (max[i] == -1) {
                this.fMaxOccurs[i] = 0;
            }
            max[i] = 0;
        }
        return true;
    }

    void removeAsDerived(int[] max, int[] used, int[] match) {
        for (int i = 1; i < this.fNumElements; ++i) {
            int b = match[i];
            if (b < 0 || used[b] < 0) continue;
            this.fMinOccurs[i] = 0;
            this.fMaxOccurs[i] = max[b];
        }
    }

    int minOccurs(int index) {
        return this.fMinOccurs[index];
    }

    int maxOccurs(int index) {
        return this.fMaxOccurs[index];
    }

    boolean isUnbounded(int index) {
        return index < this.fNumTotal ? this.fMaxOccurs[index] == -1 : true;
    }

    boolean hasOptionalContent() {
        return this.fHasOptionalContent;
    }

    int totalMin() {
        int ret = 0;
        for (int i = 1; i < this.fNumTotal; ++i) {
            ret += this.fMinOccurs[i];
        }
        return ret;
    }

    int min(int i) {
        return this.fMinOccurs[i];
    }

    XSOpenContentDecl getOpenContent() {
        return this.fOpenContent;
    }

    int calOccurs() {
        long ret = 1L;
        for (int i = 1; i < this.fNumTotal; ++i) {
            int occ = this.fMaxOccurs[i];
            if (occ == 0) continue;
            if (occ == -1) {
                int n = occ = this.fMinOccurs[i] == 0 ? 1 : this.fMinOccurs[i];
            }
            if ((ret *= (long)(occ + 1)) <= Integer.MAX_VALUE) continue;
            return -1;
        }
        return (int)ret;
    }
}

