/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl.recovery;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.TopologyRecoveryException;
import com.rabbitmq.client.impl.ConnectionParams;
import com.rabbitmq.client.impl.FrameHandlerFactory;
import com.rabbitmq.client.impl.NetworkConnection;
import com.rabbitmq.client.impl.recovery.AutorecoveringChannel;
import com.rabbitmq.client.impl.recovery.RecordedBinding;
import com.rabbitmq.client.impl.recovery.RecordedConsumer;
import com.rabbitmq.client.impl.recovery.RecordedExchange;
import com.rabbitmq.client.impl.recovery.RecordedExchangeBinding;
import com.rabbitmq.client.impl.recovery.RecordedQueue;
import com.rabbitmq.client.impl.recovery.RecordedQueueBinding;
import com.rabbitmq.client.impl.recovery.RecoveryAwareAMQConnection;
import com.rabbitmq.client.impl.recovery.RecoveryAwareAMQConnectionFactory;
import com.rabbitmq.client.impl.recovery.RecoveryAwareChannelN;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutorecoveringConnection
implements Connection,
Recoverable,
NetworkConnection {
    private final RecoveryAwareAMQConnectionFactory cf;
    private final Map<Integer, AutorecoveringChannel> channels;
    private final ConnectionParams params;
    private RecoveryAwareAMQConnection delegate;
    private final List<ShutdownListener> shutdownHooks = new ArrayList<ShutdownListener>();
    private final List<RecoveryListener> recoveryListeners = new ArrayList<RecoveryListener>();
    private final List<BlockedListener> blockedListeners = new ArrayList<BlockedListener>();
    private final Map<String, RecordedQueue> recordedQueues = new ConcurrentHashMap<String, RecordedQueue>();
    private final List<RecordedBinding> recordedBindings = new ArrayList<RecordedBinding>();
    private Map<String, RecordedExchange> recordedExchanges = new ConcurrentHashMap<String, RecordedExchange>();
    private final Map<String, RecordedConsumer> consumers = new ConcurrentHashMap<String, RecordedConsumer>();

    public AutorecoveringConnection(ConnectionParams params, FrameHandlerFactory f, Address[] addrs) {
        this.cf = new RecoveryAwareAMQConnectionFactory(params, f, addrs);
        this.params = params;
        this.channels = new ConcurrentHashMap<Integer, AutorecoveringChannel>();
    }

    public void init() throws IOException {
        this.delegate = this.cf.newConnection();
        this.addAutomaticRecoveryListener();
    }

    public void start() throws IOException {
    }

    @Override
    public Channel createChannel() throws IOException {
        RecoveryAwareChannelN ch = (RecoveryAwareChannelN)this.delegate.createChannel();
        if (ch == null) {
            return null;
        }
        return this.wrapChannel(ch);
    }

    @Override
    public Channel createChannel(int channelNumber) throws IOException {
        return this.delegate.createChannel(channelNumber);
    }

    private Channel wrapChannel(RecoveryAwareChannelN delegateChannel) {
        AutorecoveringChannel channel = new AutorecoveringChannel(this, delegateChannel);
        if (delegateChannel == null) {
            return null;
        }
        this.registerChannel(channel);
        return channel;
    }

    void registerChannel(AutorecoveringChannel channel) {
        this.channels.put(channel.getChannelNumber(), channel);
    }

    void unregisterChannel(AutorecoveringChannel channel) {
        this.channels.remove(channel.getChannelNumber());
    }

    @Override
    public Map<String, Object> getServerProperties() {
        return this.delegate.getServerProperties();
    }

    @Override
    public Map<String, Object> getClientProperties() {
        return this.delegate.getClientProperties();
    }

    @Override
    public int getFrameMax() {
        return this.delegate.getFrameMax();
    }

    @Override
    public int getHeartbeat() {
        return this.delegate.getHeartbeat();
    }

    @Override
    public int getChannelMax() {
        return this.delegate.getChannelMax();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void close(int timeout) throws IOException {
        this.delegate.close(timeout);
    }

    @Override
    public void close(int closeCode, String closeMessage, int timeout) throws IOException {
        this.delegate.close(closeCode, closeMessage, timeout);
    }

    @Override
    public void abort() {
        this.delegate.abort();
    }

    @Override
    public void abort(int closeCode, String closeMessage, int timeout) {
        this.delegate.abort(closeCode, closeMessage, timeout);
    }

    @Override
    public void abort(int closeCode, String closeMessage) {
        this.delegate.abort(closeCode, closeMessage);
    }

    @Override
    public void abort(int timeout) {
        this.delegate.abort(timeout);
    }

    @Override
    public ShutdownSignalException getCloseReason() {
        return this.delegate.getCloseReason();
    }

    @Override
    public void addBlockedListener(BlockedListener listener) {
        this.blockedListeners.add(listener);
        this.delegate.addBlockedListener(listener);
    }

    @Override
    public boolean removeBlockedListener(BlockedListener listener) {
        this.blockedListeners.remove(listener);
        return this.delegate.removeBlockedListener(listener);
    }

    @Override
    public void clearBlockedListeners() {
        this.blockedListeners.clear();
        this.delegate.clearBlockedListeners();
    }

    @Override
    public void close(int closeCode, String closeMessage) throws IOException {
        this.delegate.close(closeCode, closeMessage);
    }

    @Override
    public void addShutdownListener(ShutdownListener listener) {
        this.shutdownHooks.add(listener);
        this.delegate.addShutdownListener(listener);
    }

    @Override
    public void removeShutdownListener(ShutdownListener listener) {
        this.shutdownHooks.remove(listener);
        this.delegate.removeShutdownListener(listener);
    }

    @Override
    public void notifyListeners() {
        this.delegate.notifyListeners();
    }

    @Override
    public void addRecoveryListener(RecoveryListener listener) {
        this.recoveryListeners.add(listener);
    }

    @Override
    public void removeRecoveryListener(RecoveryListener listener) {
        this.recoveryListeners.remove(listener);
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.delegate.getExceptionHandler();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public InetAddress getAddress() {
        return this.delegate.getAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAutomaticRecoveryListener() {
        final AutorecoveringConnection c = this;
        ShutdownListener automaticRecoveryListener = new ShutdownListener(){

            public void shutdownCompleted(ShutdownSignalException cause) {
                try {
                    if (!cause.isInitiatedByApplication()) {
                        c.beginAutomaticRecovery();
                    }
                }
                catch (Exception e) {
                    c.delegate.getExceptionHandler().handleConnectionRecoveryException(c, e);
                }
            }
        };
        AutorecoveringConnection autorecoveringConnection = this;
        synchronized (autorecoveringConnection) {
            this.shutdownHooks.add(automaticRecoveryListener);
            this.delegate.addShutdownListener(automaticRecoveryListener);
        }
    }

    private synchronized void beginAutomaticRecovery() throws InterruptedException, IOException, TopologyRecoveryException {
        Thread.sleep(this.params.getNetworkRecoveryInterval());
        this.recoverConnection();
        this.recoverShutdownListeners();
        this.recoverBlockedListeners();
        this.recoverChannels();
        if (this.params.isTopologyRecoveryEnabled()) {
            this.recoverEntities();
            this.recoverConsumers();
        }
        this.notifyRecoveryListeners();
    }

    private void recoverShutdownListeners() {
        for (ShutdownListener sh : this.shutdownHooks) {
            this.delegate.addShutdownListener(sh);
        }
    }

    private void recoverBlockedListeners() {
        for (BlockedListener bl : this.blockedListeners) {
            this.delegate.addBlockedListener(bl);
        }
    }

    private void recoverConnection() throws IOException, InterruptedException {
        boolean recovering = true;
        while (recovering) {
            try {
                this.delegate = this.cf.newConnection();
                recovering = false;
            }
            catch (ConnectException ce) {
                Thread.sleep(this.params.getNetworkRecoveryInterval());
                this.getExceptionHandler().handleConnectionRecoveryException(this, ce);
            }
            catch (Exception e) {
                this.getExceptionHandler().handleConnectionRecoveryException(this, e);
            }
        }
    }

    private void recoverChannels() {
        for (AutorecoveringChannel ch : this.channels.values()) {
            try {
                ch.automaticallyRecover(this, this.delegate);
            }
            catch (Throwable t) {
                this.delegate.getExceptionHandler().handleChannelRecoveryException(ch, t);
            }
        }
    }

    private void notifyRecoveryListeners() {
        for (RecoveryListener f : this.recoveryListeners) {
            f.handleRecovery(this);
        }
    }

    private void recoverEntities() throws TopologyRecoveryException {
        this.recoverExchanges();
        this.recoverQueues();
        this.recoverBindings();
    }

    private void recoverExchanges() {
        for (RecordedExchange x : this.recordedExchanges.values()) {
            try {
                x.recover();
            }
            catch (Exception cause) {
                TopologyRecoveryException e = new TopologyRecoveryException("Caught an exception while recovering exchange " + x.getName(), cause);
                this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, x.getDelegateChannel(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverQueues() {
        for (Map.Entry<String, RecordedQueue> entry : this.recordedQueues.entrySet()) {
            String oldName = entry.getKey();
            RecordedQueue q = entry.getValue();
            try {
                q.recover();
                String newName = q.getName();
                Map<String, RecordedQueue> map = this.recordedQueues;
                synchronized (map) {
                    this.deleteRecordedQueue(oldName);
                    this.recordedQueues.put(newName, q);
                    this.propagateQueueNameChangeToBindings(oldName, newName);
                    this.propagateQueueNameChangeToConsumers(oldName, newName);
                }
            }
            catch (Exception cause) {
                TopologyRecoveryException e = new TopologyRecoveryException("Caught an exception while recovering queue " + oldName, cause);
                this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, q.getDelegateChannel(), e);
            }
        }
    }

    private void recoverBindings() {
        for (RecordedBinding b : this.recordedBindings) {
            try {
                b.recover();
            }
            catch (Exception cause) {
                String message = "Caught an exception while recovering binding between " + b.getSource() + " and " + b.getDestination();
                TopologyRecoveryException e = new TopologyRecoveryException(message, cause);
                this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, b.getDelegateChannel(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverConsumers() {
        for (Map.Entry<String, RecordedConsumer> entry : this.consumers.entrySet()) {
            String tag = entry.getKey();
            RecordedConsumer consumer = entry.getValue();
            try {
                String newTag = consumer.recover();
                Map<String, RecordedConsumer> map = this.consumers;
                synchronized (map) {
                    this.consumers.remove(tag);
                    this.consumers.put(newTag, consumer);
                }
            }
            catch (Exception cause) {
                TopologyRecoveryException e = new TopologyRecoveryException("Caught an exception while recovering consumer " + tag, cause);
                this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, consumer.getDelegateChannel(), e);
            }
        }
    }

    private void propagateQueueNameChangeToBindings(String oldName, String newName) {
        for (RecordedBinding b : this.recordedBindings) {
            if (!b.getDestination().equals(oldName)) continue;
            b.setDestination(newName);
        }
    }

    private void propagateQueueNameChangeToConsumers(String oldName, String newName) {
        for (RecordedConsumer c : this.consumers.values()) {
            if (!c.getQueue().equals(oldName)) continue;
            c.setQueue(newName);
        }
    }

    synchronized void recordQueueBinding(AutorecoveringChannel ch, String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        RecordedBinding binding = new RecordedQueueBinding(ch).source(exchange).destination(queue).routingKey(routingKey).arguments(arguments);
        if (!this.recordedBindings.contains(binding)) {
            this.recordedBindings.add(binding);
        }
    }

    synchronized boolean deleteRecordedQueueBinding(AutorecoveringChannel ch, String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        RecordedBinding b = new RecordedQueueBinding(ch).source(exchange).destination(queue).routingKey(routingKey).arguments(arguments);
        return this.recordedBindings.remove(b);
    }

    synchronized void recordExchangeBinding(AutorecoveringChannel ch, String destination, String source, String routingKey, Map<String, Object> arguments) {
        RecordedBinding binding = new RecordedExchangeBinding(ch).source(source).destination(destination).routingKey(routingKey).arguments(arguments);
        this.recordedBindings.add(binding);
    }

    synchronized boolean deleteRecordedExchangeBinding(AutorecoveringChannel ch, String destination, String source, String routingKey, Map<String, Object> arguments) {
        RecordedBinding b = new RecordedExchangeBinding(ch).source(source).destination(destination).routingKey(routingKey).arguments(arguments);
        return this.recordedBindings.remove(b);
    }

    void recordQueue(AMQP.Queue.DeclareOk ok, RecordedQueue q) {
        this.recordedQueues.put(ok.getQueue(), q);
    }

    void deleteRecordedQueue(String queue) {
        this.recordedQueues.remove(queue);
    }

    void recordExchange(String exchange, RecordedExchange x) {
        this.recordedExchanges.put(exchange, x);
    }

    void deleteRecordedExchange(String exchange) {
        this.recordedExchanges.remove(exchange);
    }

    void recordConsumer(String result, RecordedConsumer consumer) {
        this.consumers.put(result, consumer);
    }

    void deleteRecordedConsumer(String consumerTag) {
        this.consumers.remove(consumerTag);
    }
}

