/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;

@StatelessCheck
public class SingleSpaceSeparatorCheck
extends AbstractCheck {
    public static final String MSG_KEY = "single.space.separator";
    private boolean validateComments;

    public void setValidateComments(boolean validateComments) {
        this.validateComments = validateComments;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public boolean isCommentNodesRequired() {
        return this.validateComments;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.visitEachToken(rootAST);
    }

    private void visitEachToken(DetailAST node) {
        for (DetailAST sibling = node; sibling != null; sibling = sibling.getNextSibling()) {
            int columnNo = sibling.getColumnNo() - 1;
            int minSecondWhitespaceColumnNo = 2;
            if (columnNo >= 2 && !this.isTextSeparatedCorrectlyFromPrevious(this.getLine(sibling.getLineNo() - 1), columnNo)) {
                this.log(sibling.getLineNo(), columnNo, MSG_KEY, new Object[0]);
            }
            if (sibling.getChildCount() < 1) continue;
            this.visitEachToken(sibling.getFirstChild());
        }
    }

    private boolean isTextSeparatedCorrectlyFromPrevious(String line, int columnNo) {
        return SingleSpaceSeparatorCheck.isSingleSpace(line, columnNo) || !SingleSpaceSeparatorCheck.isWhitespace(line, columnNo) || SingleSpaceSeparatorCheck.isFirstInLine(line, columnNo) || !this.validateComments && SingleSpaceSeparatorCheck.isBlockCommentEnd(line, columnNo);
    }

    private static boolean isSingleSpace(String line, int columnNo) {
        return !SingleSpaceSeparatorCheck.isPrecededByMultipleWhitespaces(line, columnNo) && SingleSpaceSeparatorCheck.isSpace(line, columnNo);
    }

    private static boolean isSpace(String line, int columnNo) {
        return line.charAt(columnNo) == ' ';
    }

    private static boolean isPrecededByMultipleWhitespaces(String line, int columnNo) {
        return Character.isWhitespace(line.charAt(columnNo)) && Character.isWhitespace(line.charAt(columnNo - 1));
    }

    private static boolean isWhitespace(String line, int columnNo) {
        return Character.isWhitespace(line.charAt(columnNo));
    }

    private static boolean isFirstInLine(String line, int columnNo) {
        return CommonUtils.isBlank(line.substring(0, columnNo));
    }

    private static boolean isBlockCommentEnd(String line, int columnNo) {
        return line.substring(0, columnNo).trim().endsWith("*/");
    }
}

