/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.client.ClientFactory;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.DynamicIntProperty;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.loadbalancer.AbstractServerListFilter;
import com.netflix.loadbalancer.BaseLoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListFilter;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicServerListLoadBalancer<T extends Server>
extends BaseLoadBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicServerListLoadBalancer.class);
    boolean isSecure = false;
    boolean useTunnel = false;
    private static Thread _shutdownThread;
    protected AtomicBoolean serverListUpdateInProgress = new AtomicBoolean(false);
    private static long LISTOFSERVERS_CACHE_UPDATE_DELAY;
    private static int LISTOFSERVERS_CACHE_REPEAT_INTERVAL;
    private static ScheduledThreadPoolExecutor _serverListRefreshExecutor;
    private long refeshIntervalMills = LISTOFSERVERS_CACHE_REPEAT_INTERVAL;
    volatile ServerList<T> serverListImpl;
    volatile ServerListFilter<T> filter;
    private AtomicLong lastUpdated = new AtomicLong(System.currentTimeMillis());
    protected volatile boolean serverRefreshEnabled = false;
    private static final String CORE_THREAD = "DynamicServerListLoadBalancer.ThreadPoolSize";
    private static final DynamicIntProperty poolSizeProp;
    private volatile ScheduledFuture<?> scheduledFuture;

    public DynamicServerListLoadBalancer() {
    }

    public DynamicServerListLoadBalancer(IClientConfig clientConfig, IRule rule, IPing ping, ServerList<T> serverList, ServerListFilter<T> filter) {
        super(clientConfig, rule, ping);
        this.serverListImpl = serverList;
        this.filter = filter;
        if (filter instanceof AbstractServerListFilter) {
            ((AbstractServerListFilter)filter).setLoadBalancerStats(this.getLoadBalancerStats());
        }
        this.restOfInit(clientConfig);
    }

    public DynamicServerListLoadBalancer(IClientConfig clientConfig) {
        this.initWithNiwsConfig(clientConfig);
    }

    @Override
    public void initWithNiwsConfig(IClientConfig clientConfig) {
        try {
            ServerList niwsServerListImpl;
            super.initWithNiwsConfig(clientConfig);
            String niwsServerListClassName = clientConfig.getProperty(CommonClientConfigKey.NIWSServerListClassName, (Object)"com.netflix.loadbalancer.ConfigurationBasedServerList").toString();
            this.serverListImpl = niwsServerListImpl = (ServerList)ClientFactory.instantiateInstanceWithClientConfig(niwsServerListClassName, clientConfig);
            if (niwsServerListImpl instanceof AbstractServerList) {
                AbstractServerListFilter niwsFilter = ((AbstractServerList)niwsServerListImpl).getFilterImpl(clientConfig);
                niwsFilter.setLoadBalancerStats(this.getLoadBalancerStats());
                this.filter = niwsFilter;
            }
            this.restOfInit(clientConfig);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while initializing NIWSDiscoveryLoadBalancer:" + clientConfig.getClientName() + ", niwsClientConfig:" + clientConfig, e);
        }
    }

    void restOfInit(IClientConfig clientConfig) {
        this.refeshIntervalMills = ((Integer)clientConfig.get(CommonClientConfigKey.ServerListRefreshInterval, (Object)LISTOFSERVERS_CACHE_REPEAT_INTERVAL)).intValue();
        boolean primeConnection = this.isEnablePrimingConnections();
        this.setEnablePrimingConnections(false);
        this.enableAndInitLearnNewServersFeature();
        this.updateListOfServers();
        if (primeConnection && this.getPrimeConnections() != null) {
            this.getPrimeConnections().primeConnections(this.getServerList(true));
        }
        this.setEnablePrimingConnections(primeConnection);
        LOGGER.info("DynamicServerListLoadBalancer for client {} initialized: {}", (Object)clientConfig.getClientName(), (Object)this.toString());
    }

    @Override
    public void setServersList(List lsrv) {
        super.setServersList(lsrv);
        List serverList = lsrv;
        HashMap<String, List<Server>> serversInZones = new HashMap<String, List<Server>>();
        for (Server server : serverList) {
            this.getLoadBalancerStats().getSingleServerStat(server);
            String zone = server.getZone();
            if (zone == null) continue;
            ArrayList<Server> servers = (ArrayList<Server>)serversInZones.get(zone = zone.toLowerCase());
            if (servers == null) {
                servers = new ArrayList<Server>();
                serversInZones.put(zone, servers);
            }
            servers.add(server);
        }
        this.setServerListForZones(serversInZones);
    }

    protected void setServerListForZones(Map<String, List<Server>> zoneServersMap) {
        LOGGER.debug("Setting server list for zones: {}", zoneServersMap);
        this.getLoadBalancerStats().updateZoneServerMapping(zoneServersMap);
    }

    public ServerList<T> getServerListImpl() {
        return this.serverListImpl;
    }

    public void setServerListImpl(ServerList<T> niwsServerList) {
        this.serverListImpl = niwsServerList;
    }

    @Override
    public void setPing(IPing ping) {
        this.ping = ping;
    }

    public ServerListFilter<T> getFilter() {
        return this.filter;
    }

    public void setFilter(ServerListFilter<T> filter) {
        this.filter = filter;
    }

    @Override
    public void forceQuickPing() {
    }

    public void enableAndInitLearnNewServersFeature() {
        this.keepServerListUpdated();
        this.serverRefreshEnabled = true;
    }

    private String getIdentifier() {
        return this.getClientConfig().getClientName();
    }

    private void keepServerListUpdated() {
        this.scheduledFuture = _serverListRefreshExecutor.scheduleAtFixedRate(new ServerListRefreshExecutorThread(), LISTOFSERVERS_CACHE_UPDATE_DELAY, this.refeshIntervalMills, TimeUnit.MILLISECONDS);
    }

    private static void shutdownExecutorPool() {
        if (_serverListRefreshExecutor != null) {
            _serverListRefreshExecutor.shutdown();
            if (_shutdownThread != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(_shutdownThread);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    public void stopServerListRefreshing() {
        this.serverRefreshEnabled = false;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    @VisibleForTesting
    public void updateListOfServers() {
        List<Object> servers = new ArrayList();
        if (this.serverListImpl != null) {
            servers = this.serverListImpl.getUpdatedListOfServers();
            LOGGER.debug("List of Servers for {} obtained from Discovery client: {}", (Object)this.getIdentifier(), servers);
            if (this.filter != null) {
                servers = this.filter.getFilteredListOfServers(servers);
                LOGGER.debug("Filtered List of Servers for {} obtained from Discovery client: {}", (Object)this.getIdentifier(), servers);
            }
        }
        this.lastUpdated.set(System.currentTimeMillis());
        this.updateAllServerList(servers);
    }

    protected void updateAllServerList(List<T> ls) {
        if (this.serverListUpdateInProgress.compareAndSet(false, true)) {
            for (Server s : ls) {
                s.setAlive(true);
            }
            this.setServersList(ls);
            super.forceQuickPing();
            this.serverListUpdateInProgress.set(false);
        }
    }

    @Monitor(name="NumUpdateCyclesMissed", type=DataSourceType.GAUGE)
    public int getNumberMissedCycles() {
        if (!this.serverRefreshEnabled) {
            return 0;
        }
        return (int)((long)((int)(System.currentTimeMillis() - this.lastUpdated.get())) / this.refeshIntervalMills);
    }

    @Monitor(name="LastUpdated", type=DataSourceType.INFORMATIONAL)
    public String getLastUpdate() {
        return new Date(this.lastUpdated.get()).toString();
    }

    @Monitor(name="NumThreads", type=DataSourceType.GAUGE)
    public int getCoreThreads() {
        if (_serverListRefreshExecutor != null) {
            return _serverListRefreshExecutor.getCorePoolSize();
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("DynamicServerListLoadBalancer:");
        sb.append(super.toString());
        sb.append("ServerList:" + String.valueOf(this.serverListImpl));
        return sb.toString();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.stopServerListRefreshing();
    }

    static {
        LISTOFSERVERS_CACHE_UPDATE_DELAY = 1000L;
        LISTOFSERVERS_CACHE_REPEAT_INTERVAL = 30000;
        _serverListRefreshExecutor = null;
        poolSizeProp = new DynamicIntProperty(CORE_THREAD, 2);
        int coreSize = poolSizeProp.get();
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).build();
        _serverListRefreshExecutor = new ScheduledThreadPoolExecutor(coreSize, factory);
        poolSizeProp.addCallback(new Runnable(){

            @Override
            public void run() {
                _serverListRefreshExecutor.setCorePoolSize(poolSizeProp.get());
            }
        });
        _shutdownThread = new Thread(new Runnable(){

            @Override
            public void run() {
                LOGGER.info("Shutting down the Executor Pool for DynamicServerListLoadBalancer");
                DynamicServerListLoadBalancer.shutdownExecutorPool();
            }
        });
        Runtime.getRuntime().addShutdownHook(_shutdownThread);
    }

    class ServerListRefreshExecutorThread
    implements Runnable {
        ServerListRefreshExecutorThread() {
        }

        @Override
        public void run() {
            if (!DynamicServerListLoadBalancer.this.serverRefreshEnabled) {
                if (DynamicServerListLoadBalancer.this.scheduledFuture != null) {
                    DynamicServerListLoadBalancer.this.scheduledFuture.cancel(true);
                }
                return;
            }
            try {
                DynamicServerListLoadBalancer.this.updateListOfServers();
            }
            catch (Throwable e) {
                LOGGER.error("Exception while updating List of Servers obtained from Discovery client", e);
            }
        }
    }
}

