/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.ClasspathPropertiesConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.util.ConfigurationUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Properties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplicationProperties {
    private static final Logger logger = LoggerFactory.getLogger(WebApplicationProperties.class);
    static File appConfFolder = new File(".");
    static String baseConfigFileName = "config";
    static boolean loadLibraryProperties = true;
    static String libraryPropertiesResourceRelativePath = ClasspathPropertiesConfiguration.propertiesResourceRelativePath;

    public static void initialize(File appConfFolderFromConfig, String baseConfigFileName, boolean loadLibraryProperties, String propertiesResourceRelativePath) {
        appConfFolder = appConfFolderFromConfig;
        WebApplicationProperties.baseConfigFileName = baseConfigFileName;
        WebApplicationProperties.loadLibraryProperties = loadLibraryProperties;
        libraryPropertiesResourceRelativePath = propertiesResourceRelativePath;
        WebApplicationProperties.initialize();
    }

    public static void initialize() {
        try {
            WebApplicationProperties.initApplicationProperties();
        }
        catch (Exception e) {
            logger.error("Unable to load Application Properties", (Throwable)e);
            System.err.println("Unable to load Application Properties");
            e.printStackTrace();
        }
        if (loadLibraryProperties) {
            try {
                WebApplicationProperties.initClasspathPropertiesConfiguration();
            }
            catch (Exception e) {
                logger.error("Unable to load Library Properties", (Throwable)e);
                System.err.println("Unable to load Library Properties");
                e.printStackTrace();
            }
        }
        logger.debug("Properties loaded:" + WebApplicationProperties.getProperties());
    }

    protected static void initClasspathPropertiesConfiguration() {
        ClasspathPropertiesConfiguration.initialize();
    }

    protected static void initApplicationProperties() throws ConfigurationException, MalformedURLException {
        File appPropFile = new File(appConfFolder + "/" + baseConfigFileName + ".properties");
        File appEnvPropOverrideFile = new File(appConfFolder + "/" + baseConfigFileName + WebApplicationProperties.getEnvironment() + ".properties");
        PropertiesConfiguration appConf = new PropertiesConfiguration(appPropFile);
        PropertiesConfiguration overrideConf = new PropertiesConfiguration(appEnvPropOverrideFile);
        Properties overrideprops = ConfigurationUtils.getProperties((Configuration)overrideConf);
        for (Object prop : overrideprops.keySet()) {
            appConf.setProperty("" + prop, (Object)overrideprops.getProperty("" + prop));
        }
        String path = appPropFile.toURI().toURL().toString();
        System.setProperty("archaius.configurationSource.additionalUrls", path);
        ConfigurationManager.loadPropertiesFromConfiguration((AbstractConfiguration)appConf);
    }

    private static String getEnvironment() {
        String env = System.getProperty("env");
        return env;
    }

    public static File getAppConfFolder() {
        return appConfFolder;
    }

    public static void setAppConfFolder(File appConfFolderFromConfig, String baseConfigFileName) {
        appConfFolder = appConfFolderFromConfig;
        WebApplicationProperties.baseConfigFileName = baseConfigFileName;
    }

    public static boolean shouldLoadLibraryProperties() {
        return loadLibraryProperties;
    }

    public static void setLoadLibraryProperties(boolean loadLibraryProperties) {
        WebApplicationProperties.loadLibraryProperties = loadLibraryProperties;
    }

    public static String getLibraryPropertiesResourceRelativePath() {
        return libraryPropertiesResourceRelativePath;
    }

    public static void setLibraryPropertiesResourceRelativePath(String libraryPropertiesResourceRelativePath) {
        WebApplicationProperties.libraryPropertiesResourceRelativePath = libraryPropertiesResourceRelativePath;
    }

    public static Properties getProperties() {
        return ConfigurationUtils.getProperties((Configuration)ConfigurationManager.getConfigInstance());
    }
}

