/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.registry.impl;

import com.kidbei.rainbow.core.exception.RegistryException;
import com.kidbei.rainbow.core.registry.RainbowRegistry;
import com.kidbei.rainbow.core.registry.RegistryHook;
import com.kidbei.rainbow.core.registry.RegistryNode;
import com.kidbei.rainbow.core.util.StringHelper;
import com.kidbei.rainbow.registry.impl.ZkOps;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperRegistry
implements RainbowRegistry,
Watcher {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperRegistry.class);
    private ZooKeeper zk;
    private ZkOps ops;
    private RegistryHook hook;
    private static final ConcurrentHashMap<String, List<RegistryNode>> nodeMap = new ConcurrentHashMap();
    private CountDownLatch latch = new CountDownLatch(1);

    public ZookeeperRegistry(String zkAddresses, int timeout) {
        try {
            this.zk = new ZooKeeper(zkAddresses, timeout, (Watcher)this);
            this.ops = new ZkOps(this.zk);
            log.info("zookeeper is connect success");
            this.latch.await(10000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper \u8fde\u63a5\u5931\u8d25", (Throwable)e);
        }
    }

    public ZookeeperRegistry(String zkAddresses) {
        this(zkAddresses, 10000);
    }

    public void registerHook(RegistryHook registryHook) {
        this.hook = registryHook;
    }

    public void registerService(String group, String serviceName, RegistryNode registryNode, byte version, String data) {
        String path = StringHelper.join((Object[])new Object[]{"/", group, "/service/", serviceName, "/v", version, "/", registryNode.getHost()});
        String activePath = StringHelper.join((Object[])new Object[]{"/rainbow/services/activeServices", "/", registryNode.getHost()});
        this.remotePath(path);
        this.remotePath(activePath);
        this.ops.createByRecursion(path, data.getBytes(), CreateMode.EPHEMERAL);
        this.ops.createByRecursion(activePath, "\u5b58\u6d3b\u7684\u670d\u52a1\u8282\u70b9".getBytes(), CreateMode.EPHEMERAL);
        log.info("register node : {}", (Object)path);
    }

    public void setServiceData(String group, String serviceName, RegistryNode registryNode, byte version, String data) {
        String path = StringHelper.join((Object[])new Object[]{"/", group, "/service/", serviceName, "/v", version, "/", registryNode.getHost()});
        try {
            this.zk.setData(path, data.getBytes(), (int)version);
            log.info("set new data {} for node:{}", (Object)data, (Object)path);
        }
        catch (Exception e) {
            throw new RegistryException("\u8bbe\u7f6e\u8282\u70b9\u6570\u636e\u5931\u8d25,path=" + path, (Throwable)e);
        }
    }

    public void removeService(String group, String serviceName, RegistryNode registryNode, byte version) {
        String path = StringHelper.join((Object[])new Object[]{"/", group, "/service/", serviceName, "/v", version, "/", registryNode.getHost()});
        try {
            this.zk.delete(path, (int)version);
            log.info("remove service node:{}", (Object)path);
        }
        catch (Exception e) {
            throw new RegistryException("\u79fb\u9664\u8282\u70b9\u5931\u8d25,path=" + path, (Throwable)e);
        }
    }

    public List<RegistryNode> getServiceNodes(String group, String serviceName, byte version) {
        String path = StringHelper.join((Object[])new Object[]{"/", group, "/service/", serviceName, "/v", version});
        try {
            List nodes = this.zk.getChildren(path, false);
            if (nodes != null && nodes.size() > 0) {
                List<RegistryNode> registryNodes = nodes.stream().map(RegistryNode::new).collect(Collectors.toList());
                if (log.isDebugEnabled()) {
                    log.debug("find path {} service list {}", (Object)path, registryNodes);
                }
                return registryNodes;
            }
            return new ArrayList<RegistryNode>();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8282\u70b9\u5217\u8868\u5931\u8d25,pat={}", (Object)path, (Object)e);
            return new ArrayList<RegistryNode>();
        }
    }

    public String getData(String group, String serviceName, RegistryNode registryNode, byte version) {
        String path = StringHelper.join((Object[])new Object[]{"/", group, "/service/", serviceName, "/v", version, "/", registryNode.getHost()});
        try {
            return new String(this.zk.getData(path, false, null));
        }
        catch (Exception e) {
            throw new RegistryException("\u83b7\u53d6\u670d\u52a1\u8282\u70b9\u6570\u636e\u5931\u8d25,path=" + path, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchServiceChange(String group, String serviceName, byte version) {
        String key = serviceName + "." + version;
        String path = StringHelper.join((Object[])new Object[]{"/", group, "/service/", serviceName, "/v", version});
        ConcurrentHashMap<String, List<RegistryNode>> concurrentHashMap = nodeMap;
        synchronized (concurrentHashMap) {
            List<RegistryNode> nodes = nodeMap.get(key);
            if (nodes == null) {
                nodes = this.getServiceNodes(group, serviceName, version);
                if (nodes == null) {
                    log.info("there is no nodes for service {}->{}", (Object)serviceName, (Object)version);
                    nodes = new ArrayList<RegistryNode>();
                }
            } else {
                log.warn("watch service {}->{}", (Object)serviceName, (Object)version);
                return;
            }
            nodeMap.put(key, nodes);
            try {
                this.zk.getChildren(path, watchedEvent -> {
                    List<RegistryNode> addNodes;
                    log.info("changed -> {}", (Object)path);
                    List<RegistryNode> oldNodes = nodeMap.get(key);
                    List<RegistryNode> newNodes = this.getServiceNodes(group, serviceName, version);
                    List<RegistryNode> subNodes = this.getSubNodes(oldNodes, newNodes);
                    if (subNodes.size() > 0) {
                        log.info("offline service {}->{} sub nodes:{}", new Object[]{serviceName, version, subNodes});
                        for (RegistryNode subNode : subNodes) {
                            this.hook.serviceOffline(serviceName, subNode.getAddress(), version);
                        }
                    }
                    if ((addNodes = this.getAddNodes(oldNodes, newNodes)).size() > 0) {
                        log.info("online service {}->{} add nodes:{}", new Object[]{serviceName, version, addNodes});
                        for (RegistryNode addNode : addNodes) {
                            this.hook.serviceOnline(serviceName, addNode.getAddress(), version);
                        }
                    }
                    nodeMap.remove(key);
                    this.watchServiceChange(group, serviceName, version);
                    log.info("watch again for service {}->{}", (Object)serviceName, (Object)version);
                });
            }
            catch (Exception e) {
                throw new RegistryException("watch service " + serviceName + "->" + version + " failed", (Throwable)e);
            }
        }
    }

    private List<RegistryNode> getSubNodes(List<RegistryNode> oldNodes, List<RegistryNode> newNodes) {
        if (newNodes.size() == 0) {
            return oldNodes;
        }
        List<RegistryNode> nodes = oldNodes.stream().filter(newNode -> !newNodes.contains(newNode)).collect(Collectors.toList());
        return nodes;
    }

    private List<RegistryNode> getAddNodes(List<RegistryNode> oldNodes, List<RegistryNode> newNodes) {
        List<RegistryNode> nodes = newNodes.stream().filter(newNode -> !oldNodes.contains(newNode)).collect(Collectors.toList());
        return nodes;
    }

    public void unwatchServiceChange(String group, String serviceName, byte version) {
    }

    private void remotePath(String path) {
        try {
            if (this.ops.isExists(path)) {
                this.zk.delete(path, -1);
            }
        }
        catch (Exception e) {
            log.error("remote path error,path={}", (Object)path, (Object)e);
        }
    }

    public void process(WatchedEvent watchedEvent) {
        Watcher.Event.KeeperState stat = watchedEvent.getState();
        if (stat != Watcher.Event.KeeperState.Disconnected && stat == Watcher.Event.KeeperState.SyncConnected) {
            this.latch.countDown();
            log.info("stat : {}", (Object)stat);
        }
    }
}

