/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.registry.impl;

import com.kidbei.rainbow.registry.impl.CoopRedisLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;

public class CoopRedis {
    private JedisPool pool;

    public CoopRedis(String host, int port) {
        this(host, port, null);
    }

    public CoopRedis(String host, int port, String password) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(10);
        config.setMaxTotal(1000);
        config.setMaxWaitMillis(20000L);
        config.setTestOnBorrow(true);
        this.pool = password != null ? new JedisPool((GenericObjectPoolConfig)config, host, port, 50000, password) : new JedisPool((GenericObjectPoolConfig)config, host, port);
    }

    public Jedis getJedis() {
        return this.pool.getResource();
    }

    public long delKeysLike(final String likeKey) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                long count = 0L;
                Set keys = this.jedis.keys(likeKey + "*");
                return count += this.jedis.del(keys.toArray(new String[keys.size()])).longValue();
            }
        }.getResult();
    }

    public Long delKey(final String key) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.del(key);
            }
        }.getResult();
    }

    public Long delKeys(final String[] keys) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.del(keys);
            }
        }.getResult();
    }

    public Long expire(final String key, final int expire) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.expire(key, expire);
            }
        }.getResult();
    }

    public long makeId(final String key) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                long id = this.jedis.incr(key);
                if (id + 75807L >= Long.MAX_VALUE) {
                    this.jedis.getSet(key, "0");
                }
                return id;
            }
        }.getResult();
    }

    public Long insertToSet(final String key, final String value) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.sadd(key, new String[]{value});
            }
        }.getResult();
    }

    public Set<String> getSetMembers(final String key) {
        return (Set)new Executor<Set<String>>(this.pool){

            @Override
            Set<String> execute() {
                return this.jedis.smembers(key);
            }
        }.getResult();
    }

    public String setString(final String key, final String value) {
        return (String)new Executor<String>(this.pool){

            @Override
            String execute() {
                return this.jedis.set(key, value);
            }
        }.getResult();
    }

    public String setString(final byte[] key, final byte[] value) {
        return (String)new Executor<String>(this.pool){

            @Override
            String execute() {
                return this.jedis.set(key, value);
            }
        }.getResult();
    }

    public String setString(final byte[] key, final byte[] value, final int expire) {
        return (String)new Executor<String>(this.pool){

            @Override
            String execute() {
                return this.jedis.setex(key, expire, value);
            }
        }.getResult();
    }

    public String setString(final String key, final String value, final int expire) {
        return (String)new Executor<String>(this.pool){

            @Override
            String execute() {
                return this.jedis.setex(key, expire, value);
            }
        }.getResult();
    }

    public Long setStringIfNotExists(final String key, final String value) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.setnx(key, value);
            }
        }.getResult();
    }

    public String getString(final String key) {
        return (String)new Executor<String>(this.pool){

            @Override
            String execute() {
                return this.jedis.get(key);
            }
        }.getResult();
    }

    public byte[] getString(final byte[] key) {
        return (byte[])new Executor<byte[]>(this.pool){

            @Override
            byte[] execute() {
                return this.jedis.get(key);
            }
        }.getResult();
    }

    public List<Object> batchSetString(final List<Pair<String, String>> pairs) {
        return (List)new Executor<List<Object>>(this.pool){

            @Override
            List<Object> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                for (Pair pair : pairs) {
                    pipeline.set((String)pair.getKey(), (String)pair.getValue());
                }
                return pipeline.syncAndReturnAll();
            }
        }.getResult();
    }

    public List<String> batchGetString(final String[] keys) {
        return (List)new Executor<List<String>>(this.pool){

            @Override
            List<String> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                ArrayList<String> result = new ArrayList<String>(keys.length);
                ArrayList<Response> responses = new ArrayList<Response>(keys.length);
                for (String key : keys) {
                    responses.add(pipeline.get(key));
                }
                pipeline.sync();
                for (Response resp : responses) {
                    result.add((String)resp.get());
                }
                return result;
            }
        }.getResult();
    }

    public Long hashSet(final String key, final String field, final String value) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.hset(key, field, value);
            }
        }.getResult();
    }

    public Long hashDel(final String key, final String field) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.hdel(key, new String[]{field});
            }
        }.getResult();
    }

    public Long hashINCR(final String key, final String field) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.hincrBy(key, field, 1L);
            }
        }.getResult();
    }

    public Long hashSet(final String key, final String field, final String value, final int expire) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                Pipeline pipeline = this.jedis.pipelined();
                Response result = pipeline.hset(key, field, value);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (Long)result.get();
            }
        }.getResult();
    }

    public String hashGet(final String key, final String field) {
        return (String)new Executor<String>(this.pool){

            @Override
            String execute() {
                return this.jedis.hget(key, field);
            }
        }.getResult();
    }

    public String hashGet(final String key, final String field, final int expire) {
        return (String)new Executor<String>(this.pool){

            @Override
            String execute() {
                Pipeline pipeline = this.jedis.pipelined();
                Response result = pipeline.hget(key, field);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (String)result.get();
            }
        }.getResult();
    }

    public String hashMultipleSet(final String key, final Map<String, String> hash) {
        return (String)new Executor<String>(this.pool){

            @Override
            String execute() {
                return this.jedis.hmset(key, hash);
            }
        }.getResult();
    }

    public String hashMultipleSet(final String key, final Map<String, String> hash, final int expire) {
        return (String)new Executor<String>(this.pool){

            @Override
            String execute() {
                Pipeline pipeline = this.jedis.pipelined();
                Response result = pipeline.hmset(key, hash);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (String)result.get();
            }
        }.getResult();
    }

    public List<String> hashMultipleGet(final String key, final String ... fields) {
        return (List)new Executor<List<String>>(this.pool){

            @Override
            List<String> execute() {
                return this.jedis.hmget(key, fields);
            }
        }.getResult();
    }

    public List<String> hashMultipleGet(final String key, final int expire, final String ... fields) {
        return (List)new Executor<List<String>>(this.pool){

            @Override
            List<String> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                Response result = pipeline.hmget(key, fields);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (List)result.get();
            }
        }.getResult();
    }

    public List<String> hashSetGetAll(final String key, final int count) {
        return (List)new Executor<List<String>>(this.pool){

            @Override
            List<String> execute() {
                return this.jedis.srandmember(key, count);
            }
        }.getResult();
    }

    public List<Object> batchHashMultipleSet(final List<Pair<String, Map<String, String>>> pairs) {
        return (List)new Executor<List<Object>>(this.pool){

            @Override
            List<Object> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                for (Pair pair : pairs) {
                    pipeline.hmset((String)pair.getKey(), (Map)pair.getValue());
                }
                return pipeline.syncAndReturnAll();
            }
        }.getResult();
    }

    public List<Object> batchHashMultipleSet(final Map<String, Map<String, String>> data) {
        return (List)new Executor<List<Object>>(this.pool){

            @Override
            List<Object> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                for (Map.Entry iter : data.entrySet()) {
                    pipeline.hmset((String)iter.getKey(), (Map)iter.getValue());
                }
                return pipeline.syncAndReturnAll();
            }
        }.getResult();
    }

    public List<List<String>> batchHashMultipleGet(final List<Pair<String, String[]>> pairs) {
        return (List)new Executor<List<List<String>>>(this.pool){

            @Override
            List<List<String>> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                ArrayList<List<String>> result = new ArrayList<List<String>>(pairs.size());
                ArrayList<Response> responses = new ArrayList<Response>(pairs.size());
                for (Pair pair : pairs) {
                    responses.add(pipeline.hmget((String)pair.getKey(), (String[])pair.getValue()));
                }
                pipeline.sync();
                for (Response resp : responses) {
                    result.add((List<String>)resp.get());
                }
                return result;
            }
        }.getResult();
    }

    public Map<String, String> hashGetAll(final String key) {
        return (Map)new Executor<Map<String, String>>(this.pool){

            @Override
            Map<String, String> execute() {
                return this.jedis.hgetAll(key);
            }
        }.getResult();
    }

    public Map<String, String> hashGetAll(final String key, final int expire) {
        return (Map)new Executor<Map<String, String>>(this.pool){

            @Override
            Map<String, String> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                Response result = pipeline.hgetAll(key);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (Map)result.get();
            }
        }.getResult();
    }

    public List<Map<String, String>> batchHashGetAll(final String ... keys) {
        return (List)new Executor<List<Map<String, String>>>(this.pool){

            @Override
            List<Map<String, String>> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(keys.length);
                ArrayList<Response> responses = new ArrayList<Response>(keys.length);
                for (String key : keys) {
                    responses.add(pipeline.hgetAll(key));
                }
                pipeline.sync();
                for (Response resp : responses) {
                    result.add((Map<String, String>)resp.get());
                }
                return result;
            }
        }.getResult();
    }

    public Map<String, Map<String, String>> batchHashGetAllForMap(final String ... keys) {
        return (Map)new Executor<Map<String, Map<String, String>>>(this.pool){

            @Override
            Map<String, Map<String, String>> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                int capacity = 1;
                while ((int)((double)capacity * 0.75) <= keys.length) {
                    capacity <<= 1;
                }
                HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(capacity);
                ArrayList<Response> responses = new ArrayList<Response>(keys.length);
                for (String key : keys) {
                    responses.add(pipeline.hgetAll(key));
                }
                pipeline.sync();
                for (int i = 0; i < keys.length; ++i) {
                    result.put(keys[i], (Map<String, String>)((Response)responses.get(i)).get());
                }
                return result;
            }
        }.getResult();
    }

    public Long listPushTail(final String key, final String ... values) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.rpush(key, values);
            }
        }.getResult();
    }

    public Long listPushHead(final String key, final String value) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.lpush(key, new String[]{value});
            }
        }.getResult();
    }

    public Long listPushHead(final byte[] key, final byte[] ... values) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.lpush(key, values);
            }
        }.getResult();
    }

    public byte[] listPopHead(final byte[] key) {
        return (byte[])new Executor<byte[]>(this.pool){

            @Override
            byte[] execute() {
                return this.jedis.lpop(key);
            }
        }.getResult();
    }

    public String listPopHead(final String key) {
        return (String)new Executor<String>(this.pool){

            @Override
            String execute() {
                return this.jedis.lpop(key);
            }
        }.getResult();
    }

    public Long countList(final String key) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.llen(key);
            }
        }.getResult();
    }

    public Long countList(final byte[] key) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.llen(key);
            }
        }.getResult();
    }

    public Long listPushHeadAndTrim(final String key, final String value, final long size) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                Pipeline pipeline = this.jedis.pipelined();
                Response result = pipeline.lpush(key, new String[]{value});
                pipeline.ltrim(key, 0L, size - 1L);
                pipeline.sync();
                return (Long)result.get();
            }
        }.getResult();
    }

    public Object updateListInTransaction(final String key, final List<String> values) {
        return new Executor<Object>(this.pool){

            @Override
            Object execute() {
                Transaction transaction = this.jedis.multi();
                transaction.del(key);
                for (String value : values) {
                    transaction.rpush(key, new String[]{value});
                }
                transaction.exec();
                return null;
            }
        }.getResult();
    }

    public Long insertListIfNotExists(final String key, final String[] values) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                CoopRedisLock lock = new CoopRedisLock(key, CoopRedis.this.pool);
                lock.lock();
                try {
                    if (!this.jedis.exists(key).booleanValue()) {
                        Long l = this.jedis.rpush(key, values);
                        return l;
                    }
                }
                finally {
                    lock.unlock();
                }
                return 0L;
            }
        }.getResult();
    }

    public List<String> listGetAll(final String key) {
        return (List)new Executor<List<String>>(this.pool){

            @Override
            List<String> execute() {
                return this.jedis.lrange(key, 0L, -1L);
            }
        }.getResult();
    }

    public String delListRange(final String key, final long start, final long stop) {
        return (String)new Executor<String>(this.pool){

            @Override
            String execute() {
                return this.jedis.ltrim(key, start, stop);
            }
        }.getResult();
    }

    public String delListRange(final byte[] key, final long start, final long stop) {
        return (String)new Executor<String>(this.pool){

            @Override
            String execute() {
                return this.jedis.ltrim(key, start, stop);
            }
        }.getResult();
    }

    public List<byte[]> listGetAll(final byte[] key) {
        return (List)new Executor<List<byte[]>>(this.pool){

            @Override
            List<byte[]> execute() {
                return this.jedis.lrange(key, 0L, -1L);
            }
        }.getResult();
    }

    public List<String> listRange(final String key, final long beginIndex, final long endIndex) {
        return (List)new Executor<List<String>>(this.pool){

            @Override
            List<String> execute() {
                return this.jedis.lrange(key, beginIndex, endIndex - 1L);
            }
        }.getResult();
    }

    public List<byte[]> listRange(final byte[] key, final long start, final long end) {
        return (List)new Executor<List<byte[]>>(this.pool){

            @Override
            List<byte[]> execute() {
                return this.jedis.lrange(key, start, end - 1L);
            }
        }.getResult();
    }

    public Map<String, List<String>> batchGetAllList(final List<String> keys) {
        return (Map)new Executor<Map<String, List<String>>>(this.pool){

            @Override
            Map<String, List<String>> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                HashMap<String, List<String>> result = new HashMap<String, List<String>>();
                ArrayList<Response> responses = new ArrayList<Response>(keys.size());
                for (String key : keys) {
                    responses.add(pipeline.lrange(key, 0L, -1L));
                }
                pipeline.sync();
                for (int i = 0; i < keys.size(); ++i) {
                    result.put((String)keys.get(i), (List<String>)((Response)responses.get(i)).get());
                }
                return result;
            }
        }.getResult();
    }

    public Long publish(final String channel, final String message) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.publish(channel, message);
            }
        }.getResult();
    }

    public void subscribe(final JedisPubSub jedisPubSub, final String channel) {
        new Executor<Object>(this.pool){

            @Override
            Object execute() {
                this.jedis.subscribe(jedisPubSub, new String[]{channel});
                return null;
            }
        }.getResult();
    }

    public void unSubscribe(JedisPubSub jedisPubSub) {
        jedisPubSub.unsubscribe();
    }

    public Long addWithSortedSet(final String key, final double score, final String member) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.zadd(key, score, member);
            }
        }.getResult();
    }

    public Long addWithSortedSet(final String key, final Map<String, Double> scoreMembers) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.zadd(key, scoreMembers);
            }
        }.getResult();
    }

    public Set<String> revrangeByScoreWithSortedSet(final String key, final double max, final double min) {
        return (Set)new Executor<Set<String>>(this.pool){

            @Override
            Set<String> execute() {
                return this.jedis.zrevrangeByScore(key, max, min);
            }
        }.getResult();
    }

    public long incrBy(final String key, final long v) {
        return (Long)new Executor<Long>(this.pool){

            @Override
            Long execute() {
                return this.jedis.incrBy(key, v);
            }
        }.getResult();
    }

    public <K, V> Pair<K, V> makePair(K key, V value) {
        return new Pair<K, V>(key, value);
    }

    public static void main(String[] args) {
        CoopRedis redis = new CoopRedis("127.0.0.1", 6379);
        redis.listPushHead("list", "1");
        redis.listPushHead("list", "2");
        redis.listPushHead("list", "3");
        redis.listPushHead("list", "4");
        redis.delListRange("list", 0L, -2L);
        List<String> rs = redis.listRange("list", 0L, 4L);
        for (String r : rs) {
            System.out.println(r);
        }
        redis.delKey("list");
    }

    public class Pair<K, V> {
        private K key;
        private V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }

    abstract class Executor<T> {
        Jedis jedis;
        JedisPool jedisPool;

        public Executor(JedisPool jedisPool) {
            this.jedisPool = jedisPool;
            this.jedis = jedisPool.getResource();
        }

        abstract T execute();

        public T getResult() {
            T result = null;
            try {
                result = this.execute();
            }
            catch (Throwable e) {
                throw new RuntimeException("Redis execute exception", e);
            }
            finally {
                if (this.jedis != null) {
                    this.jedis.close();
                }
            }
            return result;
        }
    }
}

