/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.transport.netty;

import com.kidbei.rainbow.core.buffer.RPCBuf;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.util.ReferenceCountUtil;

public class NettyRPCBuf
implements RPCBuf {
    private ByteBuf buf;
    private Channel channel;

    public NettyRPCBuf(Channel channel) {
        this.channel = channel;
    }

    public NettyRPCBuf(ByteBuf buf, Channel channel) {
        this.buf = buf;
        this.channel = channel;
    }

    public RPCBuf buffer(int size) {
        this.buf = this.channel.alloc().buffer(size);
        return this;
    }

    public RPCBuf writeInt(int data) {
        this.buf.writeInt(data);
        return this;
    }

    public RPCBuf writeBool(boolean data) {
        this.buf.writeBoolean(data);
        return this;
    }

    public RPCBuf writeByte(byte data) {
        this.buf.writeByte((int)data);
        return this;
    }

    public RPCBuf writeBytes(byte[] data) {
        this.buf.writeBytes(data);
        return this;
    }

    public RPCBuf writeLong(long data) {
        this.buf.writeLong(data);
        return this;
    }

    public RPCBuf writeShort(short data) {
        this.buf.writeShort((int)data);
        return this;
    }

    public int readInt() {
        return this.buf.readInt();
    }

    public boolean readBool() {
        return this.buf.readBoolean();
    }

    public byte readByte() {
        return this.buf.readByte();
    }

    public void readBytes(byte[] readContainer) {
        this.buf.readBytes(readContainer);
    }

    public long readLong() {
        return this.buf.readLong();
    }

    public short readShort() {
        return this.buf.readShort();
    }

    public void clear() {
        this.buf.clear();
        ReferenceCountUtil.release((Object)this.buf);
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.buf.readableBytes()];
        this.readBytes(bytes);
        return bytes;
    }

    public byte[] readRemain() {
        byte[] bytes = new byte[this.buf.readableBytes()];
        this.buf.readBytes(bytes);
        return bytes;
    }

    public ByteBuf getBuf() {
        return this.buf;
    }
}

