/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.server;

import com.kidbei.rainbow.core.context.bean.ServiceDeffer;
import com.kidbei.rainbow.core.context.mapping.ProMethodMapping;
import com.kidbei.rainbow.core.handler.ServerMessageHandler;
import com.kidbei.rainbow.core.registry.RegistryNode;
import com.kidbei.rainbow.core.server.RainbowServerOptions;
import com.kidbei.rainbow.core.server.ServerSessionManager;
import com.kidbei.rainbow.core.transport.RainbowSession;
import com.kidbei.rainbow.core.transport.RainbowTransport;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RainbowServer {
    private final Logger log = LoggerFactory.getLogger(RainbowServer.class);
    private RainbowServerOptions options;
    private RainbowTransport transport;
    private ServerSessionManager sessionManager;
    private ProMethodMapping methodMapping;
    private ServerMessageHandler messageHandler;
    private String group;

    public RainbowServer(RainbowServerOptions options) {
        this.options = options;
        this.group = options.getGroup();
        this.transport = options.getTransport();
        this.methodMapping = options.getMethodMapping();
        this.messageHandler = new ServerMessageHandler(options.getSerializers(), this.methodMapping, options.getThreadPool());
        this.sessionManager = new ServerSessionManager(this.messageHandler);
    }

    public void start() {
        RainbowSession sMasterSession = this.transport.listen(this.options.getBindHost(), this.options.getPort());
        this.log.info("up server is started on {}:{}", (Object)this.options.getBindHost(), (Object)this.options.getPort());
        try {
            this.transport.registerTransportHook(this.sessionManager);
            this.registerServices(this.options.getServiceDeffers());
        }
        catch (Exception e) {
            this.log.error("server start error,close channel {}", (Object)sMasterSession, (Object)e);
        }
    }

    public void registerServices(List<ServiceDeffer> serviceDeffers) {
        for (ServiceDeffer deffer : serviceDeffers) {
            RegistryNode registryNode = new RegistryNode(this.options.getTransport().schema(), this.options.getLocalHost(), this.options.getPort());
            this.options.getRegistry().registerService(this.group, deffer.getServiceName(), registryNode, deffer.getVersion(), "ok");
            this.log.info("registry service node success,{}", (Object)registryNode);
        }
    }
}

