/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.serialize;

import com.kidbei.rainbow.core.exception.SerializeException;
import com.kidbei.rainbow.core.serialize.RainbowSerializer;
import com.kidbei.rainbow.core.serialize.impl.KryoSerializer;

public class SerializerFactory {
    private final int SERIALIZER_COUNT = 10;
    private RainbowSerializer[] serializers = new RainbowSerializer[10];
    private RainbowSerializer defaultSerializer = new KryoSerializer();

    public SerializerFactory() {
        this.registerSerializer(this.defaultSerializer);
    }

    public void registerSerializer(RainbowSerializer serializer) {
        int idx = serializer.flag() % 10;
        if (this.serializers[idx] != null) {
            throw new SerializeException("serializer alias is already exists,alias=" + serializer.flag());
        }
        this.serializers[idx] = serializer;
    }

    public RainbowSerializer getSerializer(byte flag) {
        int idx = flag % 10;
        return this.serializers[idx];
    }

    public RainbowSerializer[] getSerializers() {
        return this.serializers;
    }

    public void setSerializers(RainbowSerializer[] serializers) {
        this.serializers = serializers;
    }

    public RainbowSerializer getDefaultSerializer() {
        return this.defaultSerializer;
    }

    public void setDefaultSerializer(RainbowSerializer defaultSerializer) {
        this.defaultSerializer = defaultSerializer;
    }
}

