/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.invoke.wrapper;

import com.kidbei.rainbow.core.exception.RPCException;
import com.kidbei.rainbow.core.exception.RPCTimeoutException;
import com.kidbei.rainbow.core.invoke.wrapper.ReturnWrapper;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SyncReturnWrapper<T>
implements ReturnWrapper<T, T> {
    private CompletableFuture<T> future = new CompletableFuture();
    private static List<ReturnWrapper> returnWrappers;

    public SyncReturnWrapper(List<ReturnWrapper> returnWrappers) {
        SyncReturnWrapper.returnWrappers = returnWrappers;
    }

    public SyncReturnWrapper() {
    }

    @Override
    public boolean support(Class<?> returnType) {
        for (ReturnWrapper returnWrapper : returnWrappers) {
            if (returnWrapper instanceof SyncReturnWrapper || !returnWrapper.support(returnType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ReturnWrapper newInstance() {
        return new SyncReturnWrapper<T>();
    }

    @Override
    public void doneResult(T returnValue) {
        this.future.complete(returnValue);
    }

    @Override
    public void doneError(Throwable throwable) {
        this.future.completeExceptionally(throwable);
    }

    @Override
    public T get(long timeout) {
        try {
            return this.future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RPCTimeoutException("\u540c\u6b65\u65b9\u6cd5\u8c03\u7528\u8d85\u65f6");
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            throw new RPCException(e);
        }
    }
}

