/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.handler.result;

import com.kidbei.rainbow.core.buffer.RPCBuf;
import com.kidbei.rainbow.core.context.bean.ProMethod;
import com.kidbei.rainbow.core.handler.result.BaseReturnValueHandler;
import com.kidbei.rainbow.core.handler.result.ReturnValueHandler;
import com.kidbei.rainbow.core.protocol.ResultType;
import com.kidbei.rainbow.core.protocol.StandardHeader;
import com.kidbei.rainbow.core.protocol.codec.FuncRequest;
import com.kidbei.rainbow.core.protocol.codec.FuncResponse;
import com.kidbei.rainbow.core.protocol.codec.ResponsePayloadCodec;
import com.kidbei.rainbow.core.serialize.RainbowSerializer;
import com.kidbei.rainbow.core.transport.RainbowSession;
import java.util.List;

public class ReturnValueHandlerProcessor
extends BaseReturnValueHandler
implements ReturnValueHandler {
    private final List<ReturnValueHandler> returnValueHandlers;

    public ReturnValueHandlerProcessor(RainbowSerializer[] serializers, ResponsePayloadCodec responsePayloadCodec, List<ReturnValueHandler> returnValueHandlers) {
        super(serializers, responsePayloadCodec);
        this.returnValueHandlers = returnValueHandlers;
    }

    @Override
    public boolean support(Object returnValue, ProMethod method) {
        for (ReturnValueHandler returnValueHandler : this.returnValueHandlers) {
            if (returnValueHandler instanceof ReturnValueHandlerProcessor || !returnValueHandler.support(returnValue, method)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void handle(RainbowSession session, FuncRequest request, StandardHeader header, ProMethod method, RainbowSerializer serializer, Object returnValue) {
        FuncResponse response = new FuncResponse();
        response.hasReturnType = !request.hasReturnType;
        response.serializer = serializer.flag();
        response.resultType = ResultType.SUCCESS;
        response.result = serializer.encode(returnValue);
        if (method.getReturnType() != null) {
            response.returnType = method.getReturnType();
        } else if (!request.hasReturnType) {
            response.returnType = Void.class;
        }
        RPCBuf buf = this.responsePayloadCodec.code(session, header, response);
        session.write(buf);
    }

    public String toString() {
        return ReturnValueHandlerProcessor.class.toString();
    }
}

