/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.handler.result;

import com.kidbei.rainbow.core.buffer.RPCBuf;
import com.kidbei.rainbow.core.protocol.ResultType;
import com.kidbei.rainbow.core.protocol.StandardHeader;
import com.kidbei.rainbow.core.protocol.codec.FuncRequest;
import com.kidbei.rainbow.core.protocol.codec.FuncResponse;
import com.kidbei.rainbow.core.protocol.codec.ResponsePayloadCodec;
import com.kidbei.rainbow.core.serialize.RainbowSerializer;
import com.kidbei.rainbow.core.transport.RainbowSession;

public class BaseReturnValueHandler {
    protected RainbowSerializer[] serializers;
    protected ResponsePayloadCodec responsePayloadCodec = new ResponsePayloadCodec();
    protected RainbowSerializer stringSerializer;

    public BaseReturnValueHandler(RainbowSerializer[] serializers, ResponsePayloadCodec responsePayloadCodec) {
        this.serializers = serializers;
        this.responsePayloadCodec = responsePayloadCodec;
        this.stringSerializer = serializers[1];
    }

    protected void writeError(RainbowSession session, StandardHeader header, FuncRequest request, String errorMessage) {
        FuncResponse response = new FuncResponse();
        response.hasReturnType = !request.hasReturnType;
        response.serializer = this.stringSerializer.flag();
        response.result = this.stringSerializer.encode(errorMessage);
        response.resultType = ResultType.ERROR;
        RPCBuf buf = this.responsePayloadCodec.code(session, header, response);
        session.write(buf);
    }

    protected void writeResult(RainbowSession session, FuncRequest request, StandardHeader header, RainbowSerializer serializer, Object result) {
        FuncResponse response = new FuncResponse();
        response.hasReturnType = !request.hasReturnType;
        response.serializer = serializer.flag();
        response.resultType = ResultType.SUCCESS;
        response.result = result == null ? new byte[0] : serializer.encode(result);
        response.returnType = result.getClass();
        byte[] body = result == null ? new byte[]{} : serializer.encode(result);
        response.result = body;
        if (response.hasReturnType) {
            response.returnType = result.getClass();
        }
        RPCBuf buf = this.responsePayloadCodec.code(session, header, response);
        session.write(buf);
    }
}

