/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.context.mapping;

import com.kidbei.rainbow.core.context.annotation.RMethod;
import com.kidbei.rainbow.core.context.bean.ProMethod;
import com.kidbei.rainbow.core.context.mapping.MappingGetter;
import com.kidbei.rainbow.core.context.mapping.ServiceMapping;
import com.kidbei.rainbow.core.context.mapping.impl.MappingGetterImpl;
import com.kidbei.rainbow.core.exception.RPCException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProMethodMapping
extends ServiceMapping {
    private static final Logger log = LoggerFactory.getLogger(ProMethodMapping.class);
    private static final Map<String, ProMethod> methodMap = new HashMap<String, ProMethod>();
    private static final List<Class<?>> cache = new ArrayList();
    private MappingGetter getter = new MappingGetterImpl();

    public void addInstance(Object bean, byte version) {
        Class<?> clazz = bean.getClass();
        Class<?> ifcClass = this.checkRService(clazz);
        List<Method> rpcMethods = this.getRMethods(ifcClass);
        for (Method rpcMethod : rpcMethods) {
            List<String> uris = this.getter.getMethodUrls(ifcClass, rpcMethod);
            for (String uri : uris) {
                try {
                    ProMethod proMethod = new ProMethod(rpcMethod, bean);
                    methodMap.put(uri + ".v" + version, proMethod);
                    log.info("init mapping {}->{}", (Object)uri, (Object)proMethod);
                }
                catch (Exception e) {
                    log.info("error rpc method ", (Throwable)e);
                    throw new RPCException(e);
                }
            }
        }
        cache.add(ifcClass);
    }

    public ProMethod getRPCMethod(String uri, byte version) {
        String key = uri + ".v" + version;
        return methodMap.get(key);
    }

    private List<Method> getRMethods(Class<?> ifcClass) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        Method[] methods = ifcClass.getDeclaredMethods();
        if (methods != null) {
            for (Method method : methods) {
                RMethod rMethod = method.getAnnotation(RMethod.class);
                if (rMethod == null) continue;
                methodList.add(method);
                log.info("found rpc method : {}", (Object)method);
            }
        }
        return methodList;
    }
}

