/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.protocol;

import com.kidbei.rainbow.core.buffer.RPCBuf;
import com.kidbei.rainbow.core.protocol.ProtocolHeader;

public class StandardHeader
implements ProtocolHeader {
    public static final int HEADER_LEN = 19;
    private int len;
    private byte sign;
    private long seqId;
    private byte version;
    private int sid;
    private byte ackType;

    public StandardHeader setLen(int len) {
        this.len = len;
        return this;
    }

    public StandardHeader setVersion(byte version) {
        this.version = version;
        return this;
    }

    public StandardHeader setSeqId(long seqId) {
        this.seqId = seqId;
        return this;
    }

    public StandardHeader setAckType(byte ackType) {
        this.ackType = ackType;
        return this;
    }

    public StandardHeader setSign(byte sign) {
        this.sign = sign;
        return this;
    }

    public StandardHeader setSid(int sid) {
        this.sid = sid;
        return this;
    }

    public void writeToBuf(RPCBuf buf) {
        buf.writeInt(this.len).writeByte(this.sign).writeLong(this.seqId).writeInt(this.sid).writeByte(this.version).writeByte(this.ackType);
    }

    public static StandardHeader read(RPCBuf buf) {
        return new StandardHeader().setLen(buf.readInt()).setSign(buf.readByte()).setSeqId(buf.readLong()).setSid(buf.readInt()).setVersion(buf.readByte()).setAckType(buf.readByte());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardHeader{");
        sb.append("len=").append(this.len);
        sb.append(", sign=").append(this.sign);
        sb.append(", seqId=").append(this.seqId);
        sb.append(", version=").append(this.version);
        sb.append(", sid=").append(this.sid);
        sb.append(", ackType=").append(this.ackType);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int len() {
        return this.len;
    }

    @Override
    public byte sign() {
        return this.sign;
    }

    @Override
    public byte version() {
        return this.version;
    }

    @Override
    public long seqId() {
        return this.seqId;
    }

    @Override
    public int headerLen() {
        return 19;
    }

    @Override
    public byte ackType() {
        return this.ackType;
    }

    @Override
    public int sid() {
        return this.sid;
    }
}

