/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.context.mapping.impl;

import com.kidbei.rainbow.core.context.annotation.RMethod;
import com.kidbei.rainbow.core.context.annotation.RService;
import com.kidbei.rainbow.core.context.mapping.MappingGetter;
import com.kidbei.rainbow.core.exception.RPCException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MappingGetterImpl
implements MappingGetter {
    @Override
    public String getFullServiceName(Class<?> serviceInterface) {
        RService rService = this.checkRpcService(serviceInterface);
        if (!rService.name().equals("")) {
            return rService.name();
        }
        return serviceInterface.getName();
    }

    private RService checkRpcService(Class<?> targetService) {
        RService rService = targetService.getAnnotation(RService.class);
        if (rService == null) {
            throw new RPCException("\u975eRPC\u670d\u52a1\u7c7b:" + targetService.toString());
        }
        return rService;
    }

    @Override
    public String getSimpleServiceName(Class<?> serviceInterface) {
        List<String> names = this.getServiceNames(serviceInterface);
        return (String)names.stream().max((o1, o2) -> {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o1.length() < o2.length()) {
                return 1;
            }
            return 0;
        }).get();
    }

    @Override
    public String getBasicServiceName(Class<?> serviceInterface) {
        return serviceInterface.getSimpleName();
    }

    @Override
    public List<String> getServiceNames(Class<?> serviceInterface) {
        RService rService = this.checkRpcService(serviceInterface);
        String name = rService.name();
        if (name == null) {
            name = serviceInterface.getSimpleName();
        }
        int alias = name.hashCode();
        String aliasName = alias + "";
        String fullName = serviceInterface.getName();
        ArrayList<String> names = new ArrayList<String>();
        names.add(name);
        names.add(aliasName);
        names.add(fullName);
        return names;
    }

    private RMethod checkMethod(Method method) {
        RMethod rMethod = method.getAnnotation(RMethod.class);
        if (rMethod == null) {
            throw new RPCException("\u975eRPC\u65b9\u6cd5:" + method.toString());
        }
        return rMethod;
    }

    @Override
    public String getFullMethodName(Method method) {
        RMethod rMethod = this.checkMethod(method);
        if (!rMethod.name().equals("")) {
            return rMethod.name();
        }
        return method.getName();
    }

    @Override
    public String getSimpleMethodName(Method method) {
        List<String> names = this.getMethodNames(method);
        return (String)names.stream().max((o1, o2) -> {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o1.length() < o2.length()) {
                return 1;
            }
            return 0;
        }).get();
    }

    @Override
    public List<String> getMethodNames(Method method) {
        int alias;
        RMethod rMethod = this.checkMethod(method);
        String name = rMethod.name();
        if (name == null) {
            name = method.getName();
        }
        if ((alias = rMethod.alias()) == -1) {
            alias = name.hashCode();
        }
        String aliasName = alias + "";
        String fullName = method.getName();
        ArrayList<String> names = new ArrayList<String>();
        names.add(name);
        names.add(aliasName);
        names.add(fullName);
        return names;
    }

    @Override
    public List<String> getMethodUrls(Class<?> serviceInterface, Method method) {
        List<String> serviceNames = this.getServiceNames(serviceInterface);
        List<String> methodNames = this.getMethodNames(method);
        ArrayList<String> names = new ArrayList<String>();
        for (String serviceName : serviceNames) {
            for (String methodName : methodNames) {
                String name = serviceName + "." + methodName;
                names.add(name);
            }
        }
        return names;
    }

    @Override
    public String getSimpleMethodUrl(Class<?> serviceInterface, Method method) {
        List<String> uris = this.getMethodUrls(serviceInterface, method);
        return (String)uris.stream().max((o1, o2) -> {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o1.length() < o2.length()) {
                return 1;
            }
            return 0;
        }).get();
    }

    @Override
    public List<Method> getRPCMethods(Class<?> serviceInterface) {
        Method[] methods;
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods = serviceInterface.getDeclaredMethods()) {
            RMethod rMethod = method.getAnnotation(RMethod.class);
            if (rMethod == null) continue;
            list.add(method);
        }
        return list;
    }
}

