/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.transport.netty.bootstrap;

import com.kidbei.rainbow.core.exception.RainbowNetException;
import com.kidbei.rainbow.transport.netty.bootstrap.NettyBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerBootstrap
implements NettyBootstrap {
    private final Logger log = LoggerFactory.getLogger(NettyServerBootstrap.class);
    private ServerBootstrap bootstrap;
    private EventLoopGroup cntGroup;
    private EventLoopGroup netRwGroup;
    private Channel channel;
    private ChannelInboundHandlerAdapter inboundHandler;
    private int masterThreads = 1;
    private int childThreads = Runtime.getRuntime().availableProcessors();

    public NettyServerBootstrap(ChannelInboundHandlerAdapter inboundHandler) {
        this.inboundHandler = inboundHandler;
        this.initBootstrap();
    }

    private void initBootstrap() {
        this.cntGroup = new NioEventLoopGroup(this.masterThreads);
        this.netRwGroup = new NioEventLoopGroup(this.childThreads);
        this.bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.cntGroup, this.netRwGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT).option(ChannelOption.SO_SNDBUF, 32768)).option(ChannelOption.SO_RCVBUF, 32768)).option(ChannelOption.SO_BACKLOG, 128)).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel socketChannel) throws Exception {
                ChannelPipeline p = socketChannel.pipeline();
                p.addLast(new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, -4, 0));
                p.addLast(NettyServerBootstrap.this.inboundHandler);
            }
        });
    }

    @Override
    public void shutdown() {
        try {
            this.cntGroup.shutdownGracefully();
            this.netRwGroup.shutdownGracefully();
            this.bootstrap = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void bind(String host, int port) {
        try {
            ChannelFuture future = this.bootstrap.bind(host == null ? "0.0.0.0" : host, port);
            this.channel = future.channel();
            future.sync().awaitUninterruptibly();
        }
        catch (Exception e) {
            throw new RainbowNetException(e);
        }
        this.log.info("netty tcp server is bind on {},port:{}", (Object)host, (Object)port);
    }

    @Override
    public void connect(String host, int port) {
        throw new UnsupportedOperationException("\u670d\u52a1\u7aef\u4e0d\u652f\u6301connect\u64cd\u4f5c");
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    public NettyServerBootstrap setMasterThreads(int masterThreads) {
        this.masterThreads = masterThreads;
        return this;
    }

    public NettyServerBootstrap setChildThreads(int childThreads) {
        this.childThreads = childThreads;
        return this;
    }
}

