/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.transport.netty.bootstrap;

import com.kidbei.rainbow.core.exception.RainbowNetException;
import com.kidbei.rainbow.transport.netty.bootstrap.NettyBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientBootstrap
implements NettyBootstrap {
    private final Logger log = LoggerFactory.getLogger(NettyClientBootstrap.class);
    private Bootstrap bootstrap;
    private EventLoopGroup netGroup;
    private Channel channel;
    private ChannelInboundHandlerAdapter inboundHandler;
    private int masterThreads = 1;

    public NettyClientBootstrap(ChannelInboundHandlerAdapter inboundHandler) {
        this.inboundHandler = inboundHandler;
        this.initBootstrap();
    }

    private void initBootstrap() {
        this.netGroup = new NioEventLoopGroup(this.masterThreads);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.netGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).option(ChannelOption.SO_SNDBUF, 32768)).option(ChannelOption.SO_RCVBUF, 32768)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel socketChannel) throws Exception {
                ChannelPipeline p = socketChannel.pipeline();
                p.addLast(new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, -4, 0));
                p.addLast(NettyClientBootstrap.this.inboundHandler);
            }
        });
    }

    @Override
    public void shutdown() {
        try {
            this.netGroup.shutdownGracefully();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void bind(String host, int port) {
        throw new UnsupportedOperationException("\u5ba2\u6237\u7aef\u4e0d\u652f\u6301bind\u64cd\u4f5c");
    }

    @Override
    public void connect(String host, int port) {
        ChannelFuture future = this.bootstrap.connect(host, port);
        this.channel = future.channel();
        try {
            future.sync().awaitUninterruptibly();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RainbowNetException(e);
        }
        this.log.info("connect success to {}:{}", (Object)host, (Object)port);
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    public NettyClientBootstrap setMasterThreads(int masterThreads) {
        this.masterThreads = masterThreads;
        return this;
    }
}

