/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.transport.netty;

import com.kidbei.rainbow.core.buffer.RPCBuf;
import com.kidbei.rainbow.core.protocol.SocketType;
import com.kidbei.rainbow.core.transport.RainbowSession;
import com.kidbei.rainbow.core.transport.RainbowTransport;
import com.kidbei.rainbow.core.transport.TransportHook;
import com.kidbei.rainbow.transport.netty.NettyCMasterSession;
import com.kidbei.rainbow.transport.netty.NettyRPCBuf;
import com.kidbei.rainbow.transport.netty.NettySActiveSession;
import com.kidbei.rainbow.transport.netty.NettySMasterSession;
import com.kidbei.rainbow.transport.netty.NettySession;
import com.kidbei.rainbow.transport.netty.TcpClientBuilder;
import com.kidbei.rainbow.transport.netty.TcpServerBuilder;
import com.kidbei.rainbow.transport.netty.bootstrap.NettyClientBootstrap;
import com.kidbei.rainbow.transport.netty.bootstrap.NettyServerBootstrap;
import com.kidbei.rainbow.transport.netty.constant.NettyConstant;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTcpTransport
implements RainbowTransport {
    private static final Logger log = LoggerFactory.getLogger(NettyTcpTransport.class);
    private TransportHook transportHook;
    private TcpServerBuilder serverBuilder = () -> new NettyServerBootstrap(new ServerInboundHandler());
    private TcpClientBuilder clientBuilder = () -> new NettyClientBootstrap(new ClientInboundHandler());

    @Override
    public void registerTransportHook(TransportHook transportHook) {
        this.transportHook = transportHook;
    }

    @Override
    public byte socketType() {
        return (byte)SocketType.TCP.ordinal();
    }

    @Override
    public String schema() {
        return "tcp";
    }

    public void onNewSession(RainbowSession session) {
        this.transportHook.newActiveSession(session);
    }

    public void onCloseSession(String sessionId) {
        this.transportHook.closedSession(sessionId);
    }

    public void onMessage(String sessionId, RPCBuf data) {
        this.transportHook.receiveData(sessionId, data);
    }

    @Override
    public RainbowSession connect(String host, int port) {
        NettyClientBootstrap bootstrap = this.clientBuilder.build();
        bootstrap.connect(host, port);
        String sessionId = UUID.randomUUID().toString().replace("-", "");
        Channel channel = bootstrap.getChannel();
        channel.attr(NettyConstant.SESSION_KEY).set(sessionId);
        NettyCMasterSession session = new NettyCMasterSession(channel, host, port);
        ((NettySession)session).setSessionId(sessionId);
        session.setBootstrap(bootstrap);
        return session;
    }

    @Override
    public RainbowSession listen(String host, int port) {
        NettyServerBootstrap bootstrap = this.serverBuilder.build();
        bootstrap.bind(host, port);
        String sessionId = UUID.randomUUID().toString().replace("-", "");
        Channel channel = bootstrap.getChannel();
        channel.attr(NettyConstant.SESSION_KEY).set(sessionId);
        NettySMasterSession session = new NettySMasterSession(channel).setBootstrap(bootstrap);
        ((NettySession)session).setSessionId(sessionId);
        return session;
    }

    public NettyTcpTransport setServerBuilder(TcpServerBuilder serverBuilder) {
        this.serverBuilder = serverBuilder;
        return this;
    }

    public NettyTcpTransport setClientBuilder(TcpClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
        return this;
    }

    class ServerInboundHandler
    extends ClientInboundHandler {
        ServerInboundHandler() {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            Channel channel = ctx.channel();
            NettySActiveSession session = new NettySActiveSession(channel);
            String sessionId = UUID.randomUUID().toString().replace("-", "");
            channel.attr(NettyConstant.SESSION_KEY).set(sessionId);
            session.setSessionId(sessionId);
            NettyTcpTransport.this.onNewSession(session);
            if (log.isDebugEnabled()) {
                log.debug("up+ new session active {}", (Object)session);
            }
        }
    }

    @ChannelHandler.Sharable
    class ClientInboundHandler
    extends ChannelInboundHandlerAdapter {
        ClientInboundHandler() {
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            String sessionId = ctx.channel().attr(NettyConstant.SESSION_KEY).get();
            NettyTcpTransport.this.onCloseSession(sessionId);
            log.warn("down- channel is inactive {}", (Object)ctx.channel());
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            String sessionId = ctx.channel().attr(NettyConstant.SESSION_KEY).get();
            NettyTcpTransport.this.onCloseSession(sessionId);
            log.warn("down- channel got an exception {}", cause);
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            Channel channel = ctx.channel();
            String sessionId = channel.attr(NettyConstant.SESSION_KEY).get();
            ByteBuf buf = (ByteBuf)msg;
            NettyTcpTransport.this.onMessage(sessionId, new NettyRPCBuf(buf, channel));
        }
    }
}

