/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.transport.netty;

import com.kidbei.rainbow.core.buffer.RPCBuf;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.util.ReferenceCountUtil;

public class NettyRPCBuf
implements RPCBuf {
    private ByteBuf buf;
    private Channel channel;

    public NettyRPCBuf(Channel channel) {
        this.channel = channel;
    }

    public NettyRPCBuf(ByteBuf buf, Channel channel) {
        this.buf = buf;
        this.channel = channel;
    }

    @Override
    public RPCBuf buffer(int size) {
        this.buf = this.channel.alloc().buffer(size);
        return this;
    }

    @Override
    public RPCBuf writeInt(int data) {
        this.buf.writeInt(data);
        return this;
    }

    @Override
    public RPCBuf writeBool(boolean data) {
        this.buf.writeBoolean(data);
        return this;
    }

    @Override
    public RPCBuf writeByte(byte data) {
        this.buf.writeByte(data);
        return this;
    }

    @Override
    public RPCBuf writeBytes(byte[] data) {
        this.buf.writeBytes(data);
        return this;
    }

    @Override
    public RPCBuf writeLong(long data) {
        this.buf.writeLong(data);
        return this;
    }

    @Override
    public RPCBuf writeShort(short data) {
        this.buf.writeShort(data);
        return this;
    }

    @Override
    public int readInt() {
        return this.buf.readInt();
    }

    @Override
    public boolean readBool() {
        return this.buf.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.buf.readByte();
    }

    @Override
    public void readBytes(byte[] readContainer) {
        this.buf.readBytes(readContainer);
    }

    @Override
    public long readLong() {
        return this.buf.readLong();
    }

    @Override
    public short readShort() {
        return this.buf.readShort();
    }

    @Override
    public void clear() {
        this.buf.clear();
        ReferenceCountUtil.release(this.buf);
    }

    @Override
    public byte[] toByteArray() {
        byte[] bytes = new byte[this.buf.readableBytes()];
        this.readBytes(bytes);
        return bytes;
    }

    @Override
    public byte[] readRemain() {
        byte[] bytes = new byte[this.buf.readableBytes()];
        this.buf.readBytes(bytes);
        return bytes;
    }

    public ByteBuf getBuf() {
        return this.buf;
    }
}

