/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.regex.Pattern;

public class IPHelper {
    private static String innerHostIp = null;
    private static Pattern ipPattern = Pattern.compile("^([0-9]{1,3}\\.){3}[0-9]{1,3}$");
    private static Pattern privateIpPattern = Pattern.compile("(^127\\.0\\.0\\.1)|(^10(\\.[0-9]{1,3}){3}$)|(^172\\.1[6-9](\\.[0-9]{1,3}){2}$)|(^172\\.2[0-9](\\.[0-9]{1,3}){2}$)|(^172\\.3[0-1](\\.[0-9]{1,3}){2}$)|(^192\\.168(\\.[0-9]{1,3}){2}$)");

    public static String getInnerHostIp() {
        if (innerHostIp == null) {
            String ip = null;
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                block2: while (interfaces.hasMoreElements()) {
                    NetworkInterface iface = interfaces.nextElement();
                    if (iface.isLoopback() || !iface.isUp()) continue;
                    Enumeration<InetAddress> addresses = iface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress addr = addresses.nextElement();
                        String _tempIp = addr.getHostAddress();
                        if (!ipPattern.matcher(_tempIp).matches() || !privateIpPattern.matcher(_tempIp).matches()) continue;
                        ip = _tempIp;
                        continue block2;
                    }
                }
            }
            catch (SocketException e) {
                throw new RuntimeException(e);
            }
            innerHostIp = ip;
        }
        return innerHostIp;
    }

    public static long ipToLong(String strIp) {
        long[] ip = new long[4];
        int position1 = strIp.indexOf(".");
        int position2 = strIp.indexOf(".", position1 + 1);
        int position3 = strIp.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(strIp.substring(0, position1));
        ip[1] = Long.parseLong(strIp.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(strIp.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(strIp.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static long ipToLong(String strIp, long port) {
        long[] ip = new long[4];
        int position1 = strIp.indexOf(".");
        int position2 = strIp.indexOf(".", position1 + 1);
        int position3 = strIp.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(strIp.substring(0, position1));
        ip[1] = Long.parseLong(strIp.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(strIp.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(strIp.substring(position3 + 1));
        return (port << 32) + (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static String longToIp(long longIp) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(longIp >>> 24));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFFFL) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFL) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(longIp & 0xFFL));
        return sb.toString();
    }

    public static String longToIpHost(long longIp) {
        StringBuffer sb = new StringBuffer("");
        long port = longIp >>> 32;
        long temp = longIp & 0xFFFFFFFFL;
        sb.append(IPHelper.longToIp(temp));
        sb.append(":");
        sb.append(String.valueOf(port));
        return sb.toString();
    }

    public static String getConnectAddressBySessionId(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        String[] s1s = sessionId.split("_");
        String ip = s1s[0].split(":")[0];
        String ipHost = ip == null ? null : IPHelper.longToIpHost(Long.valueOf(ip));
        return ipHost == null ? null : ipHost.substring(0, ipHost.lastIndexOf(":"));
    }

    public static void main(String[] args) {
        System.out.println(IPHelper.getInnerHostIp());
        System.out.println(IPHelper.ipToLong(IPHelper.getInnerHostIp()));
    }
}

