/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.handler.result;

import com.kidbei.rainbow.core.handler.result.IResultVisitor;

public class AsyncResult<T>
implements IResultVisitor<T> {
    private Success success;
    private Error error;
    private Complete complete;

    public AsyncResult<T> onSuccess(Success<T> successCallback) {
        this.success = successCallback;
        return this;
    }

    public AsyncResult<T> onError(Error errorCallback) {
        this.error = errorCallback;
        return this;
    }

    public AsyncResult<T> onComplete(Complete completeCallback) {
        this.complete = completeCallback;
        return this;
    }

    @Override
    public void completeSuccess(T t) {
        if (this.success != null) {
            this.success.onResult(t);
        }
    }

    @Override
    public void complete() {
        if (this.complete != null) {
            this.complete.onComplete();
        }
    }

    @Override
    public void completeError(Throwable e) {
        if (this.error != null) {
            this.error.onError(e);
        }
    }

    public static interface Complete {
        public void onComplete();
    }

    public static interface Error {
        public void onError(Throwable var1);
    }

    public static interface Success<T> {
        public void onResult(T var1);
    }
}

