/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.client;

import com.kidbei.rainbow.core.loadbalance.LoadBalancer;
import com.kidbei.rainbow.core.transport.RainbowSession;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManager {
    private static final Logger log = LoggerFactory.getLogger(ServiceManager.class);
    private String serviceName;
    private byte version;
    private int serviceHash;
    private List<RainbowSession> sessions = new ArrayList<RainbowSession>();
    private ConcurrentHashMap<String, RainbowSession> cache = new ConcurrentHashMap();
    private List<RainbowSession> holdList = new ArrayList<RainbowSession>();

    public ServiceManager(String serviceName, byte version) {
        this.serviceName = serviceName;
        this.version = version;
        this.serviceHash = this.serviceName.hashCode();
    }

    public void addSession(RainbowSession session) {
        this.sessions.add(session);
        this.cache.put(session.sessionId(), session);
        if (log.isDebugEnabled()) {
            log.debug("add session {} for service {}", (Object)session, (Object)this);
        }
    }

    public RainbowSession removeSession(String sessionId) {
        RainbowSession session = this.cache.get(sessionId);
        this.sessions.remove(session);
        if (log.isDebugEnabled()) {
            log.debug("remove session {} for service {}", (Object)session, (Object)this);
        }
        return session;
    }

    public RainbowSession removeSessionByHost(String host) {
        RainbowSession session = this.sessions.stream().filter(session1 -> session1.getLocalAddress().equals(host)).findAny().get();
        return session;
    }

    public RainbowSession getSessionByHost(String host) {
        for (RainbowSession session : this.sessions) {
            if (!session.getRemoteAddress().equals(host)) continue;
            return session;
        }
        return null;
    }

    public RainbowSession removeSessionToHold(String sessionId) {
        RainbowSession session = this.removeSession(sessionId);
        this.holdList.add(session);
        if (log.isDebugEnabled()) {
            log.debug("remove session {} to hold,current hold list size:{}", (Object)session, (Object)this.holdList.size());
        }
        return session;
    }

    public RainbowSession selectOne(LoadBalancer loadBalancer) {
        if (log.isDebugEnabled()) {
            log.debug("call service node by loadBalancer {}", (Object)loadBalancer);
        }
        return loadBalancer.getOne(this.sessions);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public byte getVersion() {
        return this.version;
    }

    public RainbowSession getSession(String sessionId) {
        return this.cache.get(sessionId);
    }

    public int getServiceHash() {
        return this.serviceHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ServiceManager{");
        sb.append("serviceName='").append(this.serviceName).append('\'');
        sb.append(", version=").append(this.version);
        sb.append('}');
        return sb.toString();
    }
}

