/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.client;

import com.kidbei.rainbow.core.client.GlobalSessionManager;
import com.kidbei.rainbow.core.client.RainbowClientOptions;
import com.kidbei.rainbow.core.client.ServiceManager;
import com.kidbei.rainbow.core.context.annotation.RService;
import com.kidbei.rainbow.core.exception.ProxyException;
import com.kidbei.rainbow.core.handler.ClientMessageHandler;
import com.kidbei.rainbow.core.invoke.AsyncService;
import com.kidbei.rainbow.core.invoke.JdkSynchronousProxyExecutor;
import com.kidbei.rainbow.core.invoke.RemoteUriInvoker;
import com.kidbei.rainbow.core.registry.RainbowRegistry;
import com.kidbei.rainbow.core.registry.RegistryNode;
import com.kidbei.rainbow.core.transport.RainbowSession;
import com.kidbei.rainbow.core.transport.RainbowTransport;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RainbowClient {
    private final Logger log = LoggerFactory.getLogger(RainbowClient.class);
    private final Map<String, AsyncService> serviceCache = new HashMap<String, AsyncService>();
    private RainbowClientOptions options;
    private RainbowRegistry registry;
    private RainbowTransport transport;
    private GlobalSessionManager sessionManager;
    private ClientMessageHandler messageHandler;
    private long timeout;

    public RainbowClient(RainbowClientOptions options) {
        this.options = options;
        this.registry = options.getRegistry();
        this.transport = options.getTransport();
        this.messageHandler = new ClientMessageHandler(options.getSerializers(), options.getThreadPool());
        this.sessionManager = new GlobalSessionManager(options.getGroup(), this.registry, this.transport, this.messageHandler);
        this.transport.registerTransportHook(this.sessionManager);
        this.timeout = options.getTimeout();
    }

    public <T> T bindServiceIfc(Class<T> serviceIfc, int version) {
        try {
            String serviceName = this.getServiceName(serviceIfc);
            ServiceManager serviceManager = this.sessionManager.newServiceSessionManager(serviceName, (byte)version);
            this.initServiceSessions(serviceManager);
            JdkSynchronousProxyExecutor executor = new JdkSynchronousProxyExecutor(serviceManager, this.options.getSeqGenerator(), this.options.getLoadBalancer(), this.messageHandler);
            executor.setTimeout(this.timeout);
            Object object = Proxy.newProxyInstance(serviceIfc.getClassLoader(), new Class[]{serviceIfc}, executor);
            return (T)object;
        }
        catch (Exception e) {
            throw new ProxyException(e);
        }
        finally {
            this.log.info("create proxy for service : {},version:{}", (Object)serviceIfc, (Object)version);
        }
    }

    public <T> T bindServiceIfc(Class<T> serviceIfc) {
        return this.bindServiceIfc(serviceIfc, this.options.getVersion());
    }

    public <T> AsyncService<T> bindAsyncService(Class<T> serviceIfc, int version) {
        String serviceName = this.getServiceName(serviceIfc);
        String key = serviceName + version;
        AsyncService asyncService = this.serviceCache.get(key);
        if (asyncService == null) {
            ServiceManager serviceManager = this.getServiceManagerByName(serviceName, (byte)version);
            asyncService = new AsyncService<T>(serviceManager, this.options.getSeqGenerator(), this.options.getLoadBalancer(), this.messageHandler, serviceIfc).setTimeout(this.options.getTimeout());
            this.serviceCache.put(key, asyncService);
        }
        return asyncService;
    }

    public <T> AsyncService<T> bindAsyncService(Class<T> serviceIfc) {
        return this.bindAsyncService(serviceIfc, this.options.getVersion());
    }

    public Object call(String uri, int version, Object[] params, long timeout) throws TimeoutException {
        ServiceManager serviceManager = this.getServiceManager(uri, (byte)version);
        return new RemoteUriInvoker(serviceManager, this.options.getSeqGenerator(), this.options.getLoadBalancer(), this.messageHandler).invoke(uri, params, timeout);
    }

    public Object call(String uri, int version, Object[] params) throws TimeoutException {
        return this.call(uri, version, params, this.options.getTimeout());
    }

    public Object call(String uri, Object[] params) throws TimeoutException {
        return this.call(uri, this.options.getVersion(), params, this.options.getTimeout());
    }

    public Object call(String uri, Object[] params, long timeout) throws TimeoutException {
        return this.call(uri, this.options.getVersion(), params, timeout);
    }

    public <T> T call(String uri, int version, Object[] params, long timeout, Class<T> scalar) throws TimeoutException {
        ServiceManager serviceManager = this.getServiceManager(uri, (byte)version);
        return new RemoteUriInvoker(serviceManager, this.options.getSeqGenerator(), this.options.getLoadBalancer(), this.messageHandler).invoke(uri, (Object)params, timeout, scalar);
    }

    public <T> T call(String uri, int version, Object[] params, Class<T> scalar) throws TimeoutException {
        return this.call(uri, version, params, this.options.getTimeout(), scalar);
    }

    public <T> T call(String uri, Object[] params, Class<T> scalar) throws TimeoutException {
        return this.call(uri, this.options.getVersion(), params, this.options.getTimeout(), scalar);
    }

    public <T> T call(String uri, Object[] params, long timeout, Class<T> scalar) throws TimeoutException {
        return this.call(uri, this.options.getVersion(), params, timeout, scalar);
    }

    private String getServiceName(Class<?> ifcClass) {
        RService rService = ifcClass.getAnnotation(RService.class);
        if (rService == null) {
            throw new IllegalArgumentException("\u8be5\u63a5\u53e3\u6ca1\u6709\u88abRService\u6ce8\u89e3\u6807\u6ce8" + ifcClass);
        }
        String name = rService.name();
        if (name == null) {
            name = ifcClass.getSimpleName();
        }
        return name;
    }

    public void shutdown() {
        this.sessionManager.closeAllSession();
    }

    private ServiceManager getServiceManager(String uri, byte version) {
        String[] sidAndCid = uri.split("\\.");
        if (sidAndCid.length != 2) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684uri:" + uri);
        }
        String serviceName = sidAndCid[0];
        return this.getServiceManagerByName(serviceName, version);
    }

    private ServiceManager getServiceManagerByName(String serviceName, byte version) {
        ServiceManager serviceManager = this.sessionManager.getServiceManager(serviceName, version);
        if (serviceManager == null) {
            serviceManager = this.sessionManager.newServiceSessionManager(serviceName, version);
            this.initServiceSessions(serviceManager);
        }
        return serviceManager;
    }

    private void initServiceSessions(ServiceManager serviceManager) {
        List<RegistryNode> serviceNodes = this.registry.getServiceNodes(this.options.getGroup(), serviceManager.getServiceName(), serviceManager.getVersion());
        if (serviceNodes != null && serviceNodes.size() == 0) {
            this.log.warn("service {} has no active remote nodes", (Object)serviceManager.getServiceName());
        } else {
            for (RegistryNode node : serviceNodes) {
                RainbowSession session = this.transport.connect(node.getIp(), node.getPort());
                if (session.isActive()) {
                    this.sessionManager.addServiceSession(serviceManager, session);
                    this.log.info("connect remote success -> {}", (Object)node.toString());
                    continue;
                }
                this.log.warn("connect remote failed -> {}", (Object)node.toString());
            }
        }
    }
}

