/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.transport.netty;

import com.kidbei.rainbow.core.buffer.RPCBuf;
import com.kidbei.rainbow.core.transport.RainbowSession;
import com.kidbei.rainbow.transport.netty.NettyRPCBuf;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;

public class NettySession
implements RainbowSession {
    protected Channel channel;
    protected String sessionId;

    public NettySession(Channel channel) {
        this.channel = channel;
    }

    @Override
    public String sessionId() {
        return this.sessionId;
    }

    @Override
    public String getLocalAddress() {
        InetSocketAddress address = (InetSocketAddress)this.channel.localAddress();
        return address.getHostString();
    }

    @Override
    public String getRemoteAddress() {
        InetSocketAddress address = (InetSocketAddress)this.channel.remoteAddress();
        return address.getHostString();
    }

    @Override
    public boolean isActive() {
        return this.channel != null && this.channel.isActive() && this.channel.isWritable();
    }

    @Override
    public void write(RPCBuf data) {
        if (!(data instanceof NettyRPCBuf)) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u6570\u636e\u5305\u7c7b\u578b:" + data);
        }
        this.channel.writeAndFlush(((NettyRPCBuf)data).getBuf());
    }

    @Override
    public RPCBuf buffer(int size) {
        ByteBuf buf = this.channel.alloc().buffer(size);
        return new NettyRPCBuf(buf, this.channel);
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NettySession{");
        sb.append("channel=").append(this.channel);
        sb.append(", sessionId='").append(this.sessionId).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

