/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.invoke.wrapper;

import com.kidbei.rainbow.core.handler.result.RxjavaAsyncReturnValueHandler;
import com.kidbei.rainbow.core.invoke.wrapper.AsyncableReturnWrapper;
import com.kidbei.rainbow.core.invoke.wrapper.ReturnWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;

public class RxJavaReturnWrapper<T>
implements ReturnWrapper<T, Observable<T>>,
AsyncableReturnWrapper {
    private static final Logger log = LoggerFactory.getLogger(RxjavaAsyncReturnValueHandler.class);
    private Observer observer;
    private Observable<T> observable;

    @Override
    public boolean support(Class<?> returnType) {
        return returnType == Observable.class;
    }

    @Override
    public ReturnWrapper newInstance() {
        return new RxJavaReturnWrapper<T>();
    }

    @Override
    public void doneResult(T returnValue) {
        if (this.observer != null) {
            this.observer.onNext(returnValue);
        } else {
            log.warn("rx java got a result but not find a subscriber");
        }
    }

    @Override
    public void doneError(Throwable throwable) {
        if (this.observer != null) {
            this.observer.onError(throwable);
        } else {
            log.warn("rx java got a exception but not find a subscriber", throwable);
        }
    }

    @Override
    public Observable<T> get(long timeout) {
        this.observable = Observable.create(subscriber -> {
            this.observer = subscriber;
            if (log.isDebugEnabled()) {
                log.debug("new subscriber for return task");
            }
        });
        return this.observable;
    }
}

