/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.invoke;

import com.kidbei.rainbow.core.buffer.RPCBuf;
import com.kidbei.rainbow.core.client.ServiceManager;
import com.kidbei.rainbow.core.handler.ClientMessageHandler;
import com.kidbei.rainbow.core.invoke.IRemoteInvoker;
import com.kidbei.rainbow.core.invoke.PendingTask;
import com.kidbei.rainbow.core.invoke.PromiseReturnWrapper;
import com.kidbei.rainbow.core.invoke.wrapper.AsyncReturnWrapper;
import com.kidbei.rainbow.core.invoke.wrapper.AsyncableReturnWrapper;
import com.kidbei.rainbow.core.invoke.wrapper.CompletableFutureReturnWrapper;
import com.kidbei.rainbow.core.invoke.wrapper.ReturnWrapper;
import com.kidbei.rainbow.core.invoke.wrapper.RxJavaReturnWrapper;
import com.kidbei.rainbow.core.invoke.wrapper.SyncReturnWrapper;
import com.kidbei.rainbow.core.loadbalance.LoadBalancer;
import com.kidbei.rainbow.core.protocol.ACKType;
import com.kidbei.rainbow.core.protocol.StandardHeader;
import com.kidbei.rainbow.core.protocol.codec.FuncRequest;
import com.kidbei.rainbow.core.protocol.codec.HashURIRequestPayloadCodec;
import com.kidbei.rainbow.core.protocol.codec.PayloadCodec;
import com.kidbei.rainbow.core.serialize.RainbowSerializer;
import com.kidbei.rainbow.core.serialize.impl.KryoSerializer;
import com.kidbei.rainbow.core.transport.RainbowSession;
import com.kidbei.rainbow.core.util.SeqGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RemoteInvoker
implements IRemoteInvoker {
    private int serviceHash;
    private String serviceName;
    private byte version;
    protected LoadBalancer loadBalancer;
    protected SeqGenerator seqGenerator;
    protected RainbowSerializer serializer = new KryoSerializer();
    protected ServiceManager serviceManager;
    protected ClientMessageHandler messageHandler;
    protected PayloadCodec<FuncRequest, FuncRequest> payloadCodec = new HashURIRequestPayloadCodec();
    protected final List<ReturnWrapper> returnWrappers = new ArrayList<ReturnWrapper>();
    private final Map<Class<?>, ReturnWrapper> returnWrapperMap = new HashMap();

    public RemoteInvoker(ServiceManager serviceManager, SeqGenerator seqGenerator, LoadBalancer loadBalancer, ClientMessageHandler messageHandler) {
        this.serviceManager = serviceManager;
        this.seqGenerator = seqGenerator;
        this.version = serviceManager.getVersion();
        this.loadBalancer = loadBalancer;
        this.serviceName = serviceManager.getServiceName();
        this.serviceHash = this.serviceName.hashCode();
        this.messageHandler = messageHandler;
        this.initReturnWrappers();
    }

    protected void initReturnWrappers() {
        this.returnWrappers.add(new PromiseReturnWrapper());
        this.returnWrappers.add(new RxJavaReturnWrapper());
        this.returnWrappers.add(new AsyncReturnWrapper());
        this.returnWrappers.add(new CompletableFutureReturnWrapper());
        this.returnWrappers.add(new SyncReturnWrapper(this.returnWrappers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Return, Done> Return invoke(int methodHash, boolean hasReturnType, Class<Done> returnType, Object params, long timeout, ReturnWrapper<Done, Return> returnWrapper) {
        if (returnWrapper instanceof AsyncableReturnWrapper) {
            try {
                Return Return = returnWrapper.get(timeout);
                return Return;
            }
            finally {
                this.writeMessage(methodHash, hasReturnType, returnType, params, timeout, returnWrapper);
            }
        }
        this.writeMessage(methodHash, hasReturnType, returnType, params, timeout, returnWrapper);
        return returnWrapper.get(timeout);
    }

    private <Return, Done> void writeMessage(int methodHash, boolean hasReturnType, Class<Done> returnType, Object params, long timeout, ReturnWrapper<Done, Return> returnWrapper) {
        RainbowSession session = this.serviceManager.selectOne(this.loadBalancer);
        if (session == null) {
            throw new NullPointerException("no server node found for service " + this.serviceName + "->" + this.version);
        }
        StandardHeader header = new StandardHeader();
        header.setSign((byte)1);
        header.setSid(this.serviceHash);
        header.setAckType((byte)ACKType.NONE.ordinal());
        header.setVersion(this.version);
        header.setSeqId(this.seqGenerator.gen());
        byte[] args = this.serializer.encode(params);
        FuncRequest request = new FuncRequest(this.serviceHash, methodHash, hasReturnType, returnType, this.serializer.flag(), args);
        RPCBuf buf = this.payloadCodec.code(session, header, request);
        PendingTask task = new PendingTask(System.currentTimeMillis(), header.seqId(), returnWrapper, timeout, returnType);
        this.messageHandler.addTask(header.seqId(), task);
        session.write(buf);
    }

    @Override
    public <Done> Done invoke(int methodHash, boolean hasReturnType, Class<Done> returnType, Object params, long timeout) {
        ReturnWrapper returnWrapper = this.returnWrapperMap.get(returnType);
        if (returnWrapper == null) {
            for (ReturnWrapper wrapper : this.returnWrappers) {
                if (!wrapper.support(returnType)) continue;
                returnWrapper = wrapper;
                this.returnWrapperMap.put(returnType, wrapper);
            }
        }
        returnWrapper = returnWrapper.newInstance();
        return (Done)this.invoke(methodHash, hasReturnType, returnType, params, timeout, returnWrapper);
    }

    public RemoteInvoker setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return this;
    }

    public RemoteInvoker setSeqGenerator(SeqGenerator seqGenerator) {
        this.seqGenerator = seqGenerator;
        return this;
    }

    public RemoteInvoker setSerializer(RainbowSerializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public RemoteInvoker setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
        return this;
    }

    public RemoteInvoker setMessageHandler(ClientMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    public RemoteInvoker setPayloadCodec(PayloadCodec<FuncRequest, FuncRequest> payloadCodec) {
        this.payloadCodec = payloadCodec;
        return this;
    }
}

