/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.handler.result;

import com.kidbei.rainbow.core.context.bean.ProMethod;
import com.kidbei.rainbow.core.handler.result.BaseReturnValueHandler;
import com.kidbei.rainbow.core.handler.result.ReturnValueHandler;
import com.kidbei.rainbow.core.protocol.StandardHeader;
import com.kidbei.rainbow.core.protocol.codec.FuncRequest;
import com.kidbei.rainbow.core.protocol.codec.ResponsePayloadCodec;
import com.kidbei.rainbow.core.serialize.RainbowSerializer;
import com.kidbei.rainbow.core.transport.RainbowSession;
import org.jdeferred.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PromiseAsyncReturnValueHandler
extends BaseReturnValueHandler
implements ReturnValueHandler {
    private final Logger log = LoggerFactory.getLogger(PromiseAsyncReturnValueHandler.class);

    public PromiseAsyncReturnValueHandler(RainbowSerializer[] serializers, ResponsePayloadCodec responsePayloadCodec) {
        super(serializers, responsePayloadCodec);
    }

    @Override
    public boolean support(Object returnValue, ProMethod method) {
        return method.getReturnType() == Promise.class || returnValue instanceof Promise;
    }

    @Override
    public void handle(RainbowSession session, FuncRequest request, StandardHeader header, ProMethod method, RainbowSerializer serializer, Object returnValue) {
        Promise promise = (Promise)returnValue;
        promise.done(result -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug("promise done return value:{}", result);
            }
            this.writeResult(session, request, header, serializer, result);
        }).fail(e -> {
            this.log.error("promise got an error ", e);
            this.writeError(session, header, request, e.toString());
        });
    }

    public String toString() {
        return PromiseAsyncReturnValueHandler.class.toString();
    }
}

