/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.client;

import com.kidbei.rainbow.core.buffer.RPCBuf;
import com.kidbei.rainbow.core.client.ServiceManager;
import com.kidbei.rainbow.core.handler.MessageHandler;
import com.kidbei.rainbow.core.invoke.PendingTask;
import com.kidbei.rainbow.core.registry.RainbowRegistry;
import com.kidbei.rainbow.core.registry.RegistryHook;
import com.kidbei.rainbow.core.transport.CMasterSession;
import com.kidbei.rainbow.core.transport.RainbowSession;
import com.kidbei.rainbow.core.transport.RainbowTransport;
import com.kidbei.rainbow.core.transport.TransportHook;
import com.kidbei.rainbow.core.util.StringHelper;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalSessionManager
implements TransportHook,
RegistryHook {
    private static final Logger log = LoggerFactory.getLogger(GlobalSessionManager.class);
    private final ConcurrentHashMap<String, ServiceManager> managers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ServiceManager> managerCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, RainbowSession> sessionCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, PendingTask> taskMap = new ConcurrentHashMap(1000);
    private RainbowRegistry registry;
    private RainbowTransport transport;
    private MessageHandler messageHandler;
    private String group;

    public GlobalSessionManager(String group, RainbowRegistry registry, RainbowTransport transport, MessageHandler messageHandler) {
        this.group = group;
        this.registry = registry;
        this.registry.registerHook(this);
        this.transport = transport;
        this.messageHandler = messageHandler;
    }

    public ServiceManager newServiceSessionManager(String serviceName, byte version) {
        String key = StringHelper.join(this.group, ".", serviceName, ".", version);
        ServiceManager serviceManager = new ServiceManager(serviceName, version);
        this.managers.put(key, serviceManager);
        this.registry.watchServiceChange(this.group, serviceName, version);
        log.info("watch service {}->{}", (Object)serviceName, (Object)version);
        return serviceManager;
    }

    public ServiceManager getServiceManager(String serviceName, byte version) {
        String key = StringHelper.join(this.group, ".", serviceName, ".", version);
        return this.managers.get(key);
    }

    public void addServiceSession(String serviceName, byte version, RainbowSession session) {
        String key = StringHelper.join(this.group, ".", serviceName, ".", version);
        ServiceManager manager = this.managers.get(key);
        manager.addSession(session);
        this.managerCache.put(session.sessionId(), manager);
        this.sessionCache.put(session.sessionId(), session);
        log.info("up+ new session {} for service:{}", (Object)session, (Object)manager);
    }

    public void addServiceSession(ServiceManager serviceManager, RainbowSession session) {
        this.addServiceSession(serviceManager.getServiceName(), serviceManager.getVersion(), session);
    }

    public void closeAllSession() {
        for (String key : this.sessionCache.keySet()) {
            RainbowSession session = this.sessionCache.get(key);
            ((CMasterSession)session).disconnectServer();
        }
    }

    public RainbowSession getServiceSessionByHost(String serviceName, byte version, String host) {
        String key = StringHelper.join(serviceName, ".", version);
        ServiceManager manager = this.managers.get(key);
        if (manager != null) {
            return manager.getSessionByHost(host);
        }
        log.warn("serivce manager is not found {}->{}", (Object)serviceName, (Object)version);
        return null;
    }

    public RainbowSession getSession(String sessionId) {
        return this.sessionCache.get(sessionId);
    }

    public void addPendingTask(long seqId, PendingTask task) {
        this.taskMap.put(seqId, task);
    }

    @Override
    public void newActiveSession(RainbowSession session) {
        log.warn("\u5ba2\u6237\u7aef\u4e0d\u80fd\u901a\u8fc7\u6b64\u65b9\u6cd5\u6dfb\u52a0session");
    }

    @Override
    public void closedSession(String sessionId) {
        ServiceManager manager = this.managerCache.get(sessionId);
        if (manager != null) {
            RainbowSession session = manager.removeSession(sessionId);
            ((CMasterSession)session).disconnectServer();
            log.info("down- remove session:{} for service:{}", (Object)session, (Object)manager);
            this.sessionCache.remove(sessionId);
        } else {
            log.warn("err no service manager found for session {}", (Object)sessionId);
        }
    }

    @Override
    public void receiveData(String sessionId, RPCBuf data) {
        RainbowSession session = this.getSession(sessionId);
        this.messageHandler.messageReceived(session, data);
    }

    @Override
    public void serviceOnline(String serviceName, String address, byte version) {
        log.info("online new service {}-{} host:{}", serviceName, version, address);
        try {
            String[] a = address.split(":");
            RainbowSession session = this.transport.connect(a[0], Integer.valueOf(a[1]));
            if (session.isActive()) {
                log.info("socket connect {} success", (Object)address);
                this.addServiceSession(serviceName, version, session);
            }
        }
        catch (Exception e) {
            log.error("socket connect {} failed", (Object)address, (Object)e);
        }
    }

    @Override
    public void serviceOffline(String serviceName, String address, byte version) {
        RainbowSession session = this.getServiceSessionByHost(serviceName, version, address);
        if (session == null) {
            log.warn("service session is not found {}-{},host:{}", serviceName, version, address);
        } else {
            this.closedSession(session.sessionId());
            log.info("service session is closed {}-{},host:{}", serviceName, version, address);
        }
    }

    @Override
    public void registryError(Throwable throwable) {
    }
}

