/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.server;

import com.kidbei.rainbow.core.buffer.RPCBuf;
import com.kidbei.rainbow.core.handler.ServerMessageHandler;
import com.kidbei.rainbow.core.transport.RainbowSession;
import com.kidbei.rainbow.core.transport.TransportHook;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSessionManager
implements TransportHook {
    private static final Logger log = LoggerFactory.getLogger(ServerSessionManager.class);
    private final ConcurrentHashMap<String, RainbowSession> sessionMap = new ConcurrentHashMap();
    private ServerMessageHandler messageHandler;

    public ServerSessionManager(ServerMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    @Override
    public void newActiveSession(RainbowSession session) {
        if (log.isDebugEnabled()) {
            log.debug("up+ new session created:{}", (Object)session.toString());
        }
        this.sessionMap.put(session.sessionId(), session);
    }

    @Override
    public void closedSession(String sessionId) {
        RainbowSession session = this.sessionMap.remove(sessionId);
        if (log.isDebugEnabled()) {
            log.debug("down- session is closed:{}", (Object)session.toString());
        }
    }

    @Override
    public void receiveData(String sessionId, RPCBuf o) {
        RainbowSession session = this.sessionMap.get(sessionId);
        if (session == null) {
            log.warn("why session is null ?");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("received message from session:{}", (Object)session);
            }
            this.messageHandler.messageReceived(session, o);
        }
    }
}

