/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.protocol.codec;

import com.kidbei.rainbow.core.buffer.RPCBuf;
import com.kidbei.rainbow.core.exception.ProtocolException;
import com.kidbei.rainbow.core.protocol.ACKType;
import com.kidbei.rainbow.core.protocol.StandardHeader;
import com.kidbei.rainbow.core.protocol.codec.FuncRequest;
import com.kidbei.rainbow.core.protocol.codec.PayloadCodec;
import com.kidbei.rainbow.core.transport.RainbowSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashURIRequestPayloadCodec
implements PayloadCodec<FuncRequest, FuncRequest> {
    private static final Logger log = LoggerFactory.getLogger(HashURIRequestPayloadCodec.class);

    @Override
    public RPCBuf code(RainbowSession session, StandardHeader header, FuncRequest request) {
        try {
            int len = 26;
            byte[] argBytes = request.params;
            RPCBuf buf = session.buffer(len += argBytes.length);
            header.setSign((byte)1).setLen(len).setSid(request.serviceHash).setAckType((byte)ACKType.NONE.ordinal());
            header.writeToBuf(buf);
            buf.writeByte((byte)1);
            buf.writeInt(request.methodHash);
            buf.writeByte(request.serializer);
            buf.writeBool(request.hasReturnType);
            buf.writeBytes(argBytes);
            RPCBuf rPCBuf = buf;
            return rPCBuf;
        }
        catch (Exception e) {
            throw new ProtocolException(e);
        }
        finally {
            header = null;
            request = null;
        }
    }

    @Override
    public FuncRequest decode(StandardHeader header, RPCBuf buf) {
        byte payloadType = buf.readByte();
        if (payloadType != 1) {
            throw new ProtocolException("\u9519\u8bef\u7684\u5305\u4f53:" + payloadType);
        }
        int sid = header.sid();
        int cid = buf.readInt();
        byte serializeType = buf.readByte();
        boolean hasReturnType = buf.readBool();
        byte[] argBytes = buf.readRemain();
        String uri = sid + "." + cid;
        FuncRequest request = new FuncRequest();
        request.uri = uri;
        request.serviceHash = sid;
        request.methodHash = cid;
        request.serializer = serializeType;
        request.uri = uri;
        request.hasReturnType = hasReturnType;
        request.params = argBytes;
        return request;
    }

    @Override
    public byte payloadType() {
        return 1;
    }
}

