/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.invoke;

import com.kidbei.rainbow.core.client.ServiceManager;
import com.kidbei.rainbow.core.context.annotation.RMethod;
import com.kidbei.rainbow.core.handler.ClientMessageHandler;
import com.kidbei.rainbow.core.invoke.IRemoteMethodInvoker;
import com.kidbei.rainbow.core.invoke.RemoteInvoker;
import com.kidbei.rainbow.core.invoke.wrapper.ReturnWrapper;
import com.kidbei.rainbow.core.loadbalance.LoadBalancer;
import com.kidbei.rainbow.core.util.SeqGenerator;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class RemoteMethodInvoker
extends RemoteInvoker
implements IRemoteMethodInvoker {
    private final Map<Method, Integer> hashCache = new HashMap<Method, Integer>();

    public RemoteMethodInvoker(ServiceManager serviceManager, SeqGenerator seqGenerator, LoadBalancer loadBalancer, ClientMessageHandler messageHandler) {
        super(serviceManager, seqGenerator, loadBalancer, messageHandler);
    }

    @Override
    public <Done, Return> Return invoke(Method method, Object params, long timeout, ReturnWrapper<Done, Return> returnWrapper) throws TimeoutException {
        int methodHash = this.getMethodHash(method);
        return this.invoke(methodHash, true, method.getReturnType(), params, timeout, returnWrapper);
    }

    private int getMethodHash(Method method) {
        Integer hash = this.hashCache.get(method);
        if (hash != null) {
            return hash;
        }
        String name = method.getName();
        RMethod rMethod = method.getAnnotation(RMethod.class);
        String rName = rMethod.name();
        if (!rName.equals("")) {
            name = rName;
        }
        hash = name.hashCode();
        this.hashCache.put(method, hash);
        return hash;
    }

    @Override
    public Object invoke(Method method, Object params, long timeout) throws TimeoutException {
        int methodHash = this.getMethodHash(method);
        return this.invoke(methodHash, true, method.getReturnType(), params, timeout);
    }
}

