/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.handler.result;

import com.kidbei.rainbow.core.context.bean.ProMethod;
import com.kidbei.rainbow.core.handler.result.BaseReturnValueHandler;
import com.kidbei.rainbow.core.handler.result.ReturnValueHandler;
import com.kidbei.rainbow.core.protocol.StandardHeader;
import com.kidbei.rainbow.core.protocol.codec.FuncRequest;
import com.kidbei.rainbow.core.protocol.codec.ResponsePayloadCodec;
import com.kidbei.rainbow.core.serialize.RainbowSerializer;
import com.kidbei.rainbow.core.transport.RainbowSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class RxjavaAsyncReturnValueHandler
extends BaseReturnValueHandler
implements ReturnValueHandler {
    private static final Logger log = LoggerFactory.getLogger(RxjavaAsyncReturnValueHandler.class);

    public RxjavaAsyncReturnValueHandler(RainbowSerializer[] serializers, ResponsePayloadCodec responsePayloadCodec) {
        super(serializers, responsePayloadCodec);
    }

    @Override
    public boolean support(Object returnValue, ProMethod method) {
        return returnValue instanceof Observable;
    }

    @Override
    public void handle(RainbowSession session, FuncRequest request, StandardHeader header, ProMethod method, RainbowSerializer serializer, Object returnValue) {
        Observable observable = (Observable)returnValue;
        observable.subscribe(result -> {
            if (log.isDebugEnabled()) {
                log.debug("subscribe a return value:{}", result);
            }
            this.writeResult(session, request, header, serializer, result);
        }, throwable -> {
            log.error("subscribe a error ", throwable);
            this.writeError(session, header, request, throwable.toString());
        });
    }
}

