/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.context.bean;

import com.kidbei.rainbow.core.util.MethodParameterNameDiscover;
import com.kidbei.rainbow.core.util.impl.JavassistMethodParameterNameDiscover;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class ProMethodParam {
    private Method method;
    private String paramName;
    private Class<?> paramType;
    private Annotation[] annotations;
    private int methodIndex;
    private MethodParameterNameDiscover parameterDiscover;

    public ProMethodParam(Method method, Class<?> paramType, int methodIndex) {
        this(method, paramType, methodIndex, new JavassistMethodParameterNameDiscover());
    }

    public ProMethodParam(Method method, Class<?> paramType, int methodIndex, MethodParameterNameDiscover parameterDiscover) {
        this.method = method;
        this.paramType = paramType;
        this.methodIndex = methodIndex;
        this.parameterDiscover = parameterDiscover;
    }

    public String getParamName() {
        String[] names;
        if (this.paramName == null && (names = this.parameterDiscover.getParameterNames(this.method)) != null) {
            this.paramName = names[this.methodIndex];
        }
        return this.paramName;
    }

    public boolean hasParameterAnnotations() {
        return this.getParameterAnnotations().length != 0;
    }

    public <T extends Annotation> boolean hasParameterAnnotation(Class<T> annotationType) {
        return this.getParameterAnnotation(annotationType) != null;
    }

    public <T extends Annotation> T getParameterAnnotation(Class<T> annotationType) {
        Annotation[] anns;
        for (Annotation ann : anns = this.getParameterAnnotations()) {
            if (!annotationType.isInstance(ann)) continue;
            return (T)ann;
        }
        return null;
    }

    public Annotation[] getParameterAnnotations() {
        Annotation[][] methodAnnotations = this.method.getParameterAnnotations();
        if (this.annotations == null) {
            this.annotations = methodAnnotations[this.methodIndex];
            if (this.annotations == null) {
                this.annotations = new Annotation[0];
            }
        }
        return this.annotations;
    }
}

