/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.benchmark;

import com.kidbei.rainbow.HelloService;
import com.kidbei.rainbow.core.client.RainbowClient;
import com.kidbei.rainbow.core.client.RainbowClientOptions;
import com.kidbei.rainbow.registry.impl.ZookeeperRegistry;
import com.kidbei.rainbow.transport.netty.NettyTcpTransport;
import java.util.concurrent.CompletableFuture;

public class TestRainbowClient {
    public static void main(String[] args) throws InterruptedException {
        NettyTcpTransport transport = new NettyTcpTransport();
        RainbowClientOptions options = new RainbowClientOptions();
        options.setRegistry(new ZookeeperRegistry("127.0.0.1:2181", 1000));
        options.setVersion(2);
        options.setTransport(transport);
        try {
            HelloService service = new RainbowClient(options).bindServiceIfc(HelloService.class, 1);
            for (int i = 0; i < 1000; ++i) {
                service.sayHello("kidbei");
                CompletableFuture<String> completableFuture = service.sayFuture("ff");
            }
            long start = System.nanoTime();
            for (int i = 0; i < 10000; ++i) {
                String string = service.sayHello("kidbei");
            }
            long end = System.nanoTime();
            System.out.println((double)(end - start) / 1.0E9);
            System.out.println("qps:" + 10000.0 / ((double)(end - start) / 1.0E9));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

