/*
 * Decompiled with CFR 0.152.
 */
package org.jdeferred.impl;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdeferred.AlwaysCallback;
import org.jdeferred.DoneCallback;
import org.jdeferred.DoneFilter;
import org.jdeferred.DonePipe;
import org.jdeferred.FailCallback;
import org.jdeferred.FailFilter;
import org.jdeferred.FailPipe;
import org.jdeferred.ProgressCallback;
import org.jdeferred.ProgressFilter;
import org.jdeferred.ProgressPipe;
import org.jdeferred.Promise;
import org.jdeferred.impl.FilteredPromise;
import org.jdeferred.impl.PipedPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPromise<D, F, P>
implements Promise<D, F, P> {
    protected final Logger log = LoggerFactory.getLogger(AbstractPromise.class);
    protected volatile Promise.State state = Promise.State.PENDING;
    protected final List<DoneCallback<D>> doneCallbacks = new CopyOnWriteArrayList<DoneCallback<D>>();
    protected final List<FailCallback<F>> failCallbacks = new CopyOnWriteArrayList<FailCallback<F>>();
    protected final List<ProgressCallback<P>> progressCallbacks = new CopyOnWriteArrayList<ProgressCallback<P>>();
    protected final List<AlwaysCallback<D, F>> alwaysCallbacks = new CopyOnWriteArrayList<AlwaysCallback<D, F>>();
    protected D resolveResult;
    protected F rejectResult;

    @Override
    public Promise.State state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<D, F, P> done(DoneCallback<D> callback) {
        AbstractPromise abstractPromise = this;
        synchronized (abstractPromise) {
            if (this.isResolved()) {
                this.triggerDone(callback, this.resolveResult);
            } else {
                this.doneCallbacks.add(callback);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<D, F, P> fail(FailCallback<F> callback) {
        AbstractPromise abstractPromise = this;
        synchronized (abstractPromise) {
            if (this.isRejected()) {
                this.triggerFail(callback, this.rejectResult);
            } else {
                this.failCallbacks.add(callback);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<D, F, P> always(AlwaysCallback<D, F> callback) {
        AbstractPromise abstractPromise = this;
        synchronized (abstractPromise) {
            if (this.isPending()) {
                this.alwaysCallbacks.add(callback);
            } else {
                this.triggerAlways(callback, this.state, this.resolveResult, this.rejectResult);
            }
        }
        return this;
    }

    protected void triggerDone(D resolved) {
        for (DoneCallback<D> callback : this.doneCallbacks) {
            try {
                this.triggerDone(callback, resolved);
            }
            catch (Exception e) {
                this.log.error("an uncaught exception occured in a DoneCallback", e);
            }
        }
        this.doneCallbacks.clear();
    }

    protected void triggerDone(DoneCallback<D> callback, D resolved) {
        callback.onDone(resolved);
    }

    protected void triggerFail(F rejected) {
        for (FailCallback<F> callback : this.failCallbacks) {
            try {
                this.triggerFail(callback, rejected);
            }
            catch (Exception e) {
                this.log.error("an uncaught exception occured in a FailCallback", e);
            }
        }
        this.failCallbacks.clear();
    }

    protected void triggerFail(FailCallback<F> callback, F rejected) {
        callback.onFail(rejected);
    }

    protected void triggerProgress(P progress) {
        for (ProgressCallback<P> callback : this.progressCallbacks) {
            try {
                this.triggerProgress(callback, progress);
            }
            catch (Exception e) {
                this.log.error("an uncaught exception occured in a ProgressCallback", e);
            }
        }
    }

    protected void triggerProgress(ProgressCallback<P> callback, P progress) {
        callback.onProgress(progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerAlways(Promise.State state, D resolve, F reject) {
        for (AlwaysCallback<D, F> callback : this.alwaysCallbacks) {
            try {
                this.triggerAlways(callback, state, resolve, reject);
            }
            catch (Exception e) {
                this.log.error("an uncaught exception occured in a AlwaysCallback", e);
            }
        }
        this.alwaysCallbacks.clear();
        AbstractPromise abstractPromise = this;
        synchronized (abstractPromise) {
            this.notifyAll();
        }
    }

    protected void triggerAlways(AlwaysCallback<D, F> callback, Promise.State state, D resolve, F reject) {
        callback.onAlways(state, resolve, reject);
    }

    @Override
    public Promise<D, F, P> progress(ProgressCallback<P> callback) {
        this.progressCallbacks.add(callback);
        return this;
    }

    @Override
    public Promise<D, F, P> then(DoneCallback<D> callback) {
        return this.done(callback);
    }

    @Override
    public Promise<D, F, P> then(DoneCallback<D> doneCallback, FailCallback<F> failCallback) {
        this.done(doneCallback);
        this.fail(failCallback);
        return this;
    }

    @Override
    public Promise<D, F, P> then(DoneCallback<D> doneCallback, FailCallback<F> failCallback, ProgressCallback<P> progressCallback) {
        this.done(doneCallback);
        this.fail(failCallback);
        this.progress(progressCallback);
        return this;
    }

    @Override
    public <D_OUT, F_OUT, P_OUT> Promise<D_OUT, F_OUT, P_OUT> then(DoneFilter<D, D_OUT> doneFilter) {
        return new FilteredPromise(this, doneFilter, null, null);
    }

    @Override
    public <D_OUT, F_OUT, P_OUT> Promise<D_OUT, F_OUT, P_OUT> then(DoneFilter<D, D_OUT> doneFilter, FailFilter<F, F_OUT> failFilter) {
        return new FilteredPromise(this, doneFilter, failFilter, null);
    }

    @Override
    public <D_OUT, F_OUT, P_OUT> Promise<D_OUT, F_OUT, P_OUT> then(DoneFilter<D, D_OUT> doneFilter, FailFilter<F, F_OUT> failFilter, ProgressFilter<P, P_OUT> progressFilter) {
        return new FilteredPromise<D, F, P, D_OUT, F_OUT, P_OUT>(this, doneFilter, failFilter, progressFilter);
    }

    @Override
    public <D_OUT, F_OUT, P_OUT> Promise<D_OUT, F_OUT, P_OUT> then(DonePipe<D, D_OUT, F_OUT, P_OUT> doneFilter) {
        return new PipedPromise(this, doneFilter, null, null);
    }

    @Override
    public <D_OUT, F_OUT, P_OUT> Promise<D_OUT, F_OUT, P_OUT> then(DonePipe<D, D_OUT, F_OUT, P_OUT> doneFilter, FailPipe<F, D_OUT, F_OUT, P_OUT> failFilter) {
        return new PipedPromise(this, doneFilter, failFilter, null);
    }

    @Override
    public <D_OUT, F_OUT, P_OUT> Promise<D_OUT, F_OUT, P_OUT> then(DonePipe<D, D_OUT, F_OUT, P_OUT> doneFilter, FailPipe<F, D_OUT, F_OUT, P_OUT> failFilter, ProgressPipe<P, D_OUT, F_OUT, P_OUT> progressFilter) {
        return new PipedPromise<D, F, P, D_OUT, F_OUT, P_OUT>(this, doneFilter, failFilter, progressFilter);
    }

    @Override
    public boolean isPending() {
        return this.state == Promise.State.PENDING;
    }

    @Override
    public boolean isResolved() {
        return this.state == Promise.State.RESOLVED;
    }

    @Override
    public boolean isRejected() {
        return this.state == Promise.State.REJECTED;
    }

    @Override
    public void waitSafely() throws InterruptedException {
        this.waitSafely(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitSafely(long timeout) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        AbstractPromise abstractPromise = this;
        synchronized (abstractPromise) {
            while (this.isPending()) {
                try {
                    if (timeout <= 0L) {
                        this.wait();
                    } else {
                        long elapsed = System.currentTimeMillis() - startTime;
                        long waitTime = timeout - elapsed;
                        this.wait(waitTime);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
                if (timeout <= 0L || System.currentTimeMillis() - startTime < timeout) continue;
                return;
            }
        }
    }
}

